/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CodeCompletionPanel
extends JPanel
implements DocumentListener {
    public static final String JAVA_AUTO_POPUP_ON_IDENTIFIER_PART = "javaAutoPopupOnIdentifierPart";
    public static final boolean JAVA_AUTO_POPUP_ON_IDENTIFIER_PART_DEFAULT = false;
    public static final String JAVA_AUTO_COMPLETION_TRIGGERS = "javaAutoCompletionTriggers";
    public static final String JAVA_AUTO_COMPLETION_TRIGGERS_DEFAULT = ".";
    public static final String JAVA_COMPLETION_SELECTORS = "javaCompletionSelectors";
    public static final String JAVA_COMPLETION_SELECTORS_DEFAULT = ".,;:([+-=";
    public static final String JAVADOC_AUTO_COMPLETION_TRIGGERS = "javadocAutoCompletionTriggers";
    public static final String JAVADOC_AUTO_COMPLETION_TRIGGERS_DEFAULT = ".#@";
    public static final String JAVADOC_COMPLETION_SELECTORS = "javadocCompletionSelectors";
    public static final String JAVADOC_COMPLETION_SELECTORS_DEFAULT = ".#";
    public static final String GUESS_METHOD_ARGUMENTS = "guessMethodArguments";
    public static final boolean GUESS_METHOD_ARGUMENTS_DEFAULT = true;
    public static final String JAVA_COMPLETION_WHITELIST = "javaCompletionWhitelist";
    public static final String JAVA_COMPLETION_WHITELIST_DEFAULT = "";
    public static final String JAVA_COMPLETION_BLACKLIST = "javaCompletionBlacklist";
    public static final String JAVA_COMPLETION_BLACKLIST_DEFAULT = "";
    public static final String JAVA_COMPLETION_EXCLUDER_METHODS = "javaCompletionExcluderMethods";
    public static final boolean JAVA_COMPLETION_EXCLUDER_METHODS_DEFAULT = false;
    public static final String JAVA_AUTO_COMPLETION_SUBWORDS = "javaCompletionSubwords";
    public static final boolean JAVA_AUTO_COMPLETION_SUBWORDS_DEFAULT = false;
    private static final String JAVA_FQN_REGEX = "[$\\p{L}\\p{Digit}._]*\\*?";
    private final Preferences preferences;
    private volatile String javaExcluderEditing;
    private final Map<String, Object> id2Saved = new HashMap<String, Object>();
    private JCheckBox guessMethodArguments;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JCheckBox javaAutoCompletionSubwords;
    private JTextField javaAutoCompletionTriggersField;
    private JLabel javaAutoCompletionTriggersLabel;
    private JCheckBox javaAutoPopupOnIdentifierPart;
    private JList javaCompletionExcludeJlist;
    private JScrollPane javaCompletionExcludeScrollPane;
    private JButton javaCompletionExcluderAddButton;
    private JDialog javaCompletionExcluderDialog2;
    private JButton javaCompletionExcluderDialogCancelButton;
    private JLabel javaCompletionExcluderDialogLabel;
    private JButton javaCompletionExcluderDialogOkButton;
    private JTextField javaCompletionExcluderDialogTextField;
    private JButton javaCompletionExcluderEditButton;
    private JLabel javaCompletionExcluderLabel;
    private JCheckBox javaCompletionExcluderMethodsCheckBox;
    private JButton javaCompletionExcluderRemoveButton;
    private JTabbedPane javaCompletionExcluderTab;
    private JList javaCompletionIncludeJlist;
    private JScrollPane javaCompletionIncludeScrollPane;
    private JTextField javaCompletionSelectorsField;
    private JLabel javaCompletionSelectorsLabel;
    private JTextField javadocAutoCompletionTriggersField;
    private JLabel javadocAutoCompletionTriggersLabel;
    private JTextField javadocCompletionSelectorsField;
    private JLabel javadocCompletionSelectorsLabel;

    public CodeCompletionPanel(Preferences p) {
        this.initComponents();
        this.preferences = p;
        this.guessMethodArguments.setSelected(this.preferences.getBoolean(GUESS_METHOD_ARGUMENTS, true));
        this.javaAutoPopupOnIdentifierPart.setSelected(this.preferences.getBoolean(JAVA_AUTO_POPUP_ON_IDENTIFIER_PART, false));
        this.javaAutoCompletionTriggersField.setText(this.preferences.get(JAVA_AUTO_COMPLETION_TRIGGERS, JAVA_AUTO_COMPLETION_TRIGGERS_DEFAULT));
        this.javaCompletionSelectorsField.setText(this.preferences.get(JAVA_COMPLETION_SELECTORS, JAVA_COMPLETION_SELECTORS_DEFAULT));
        this.javaAutoCompletionSubwords.setSelected(this.preferences.getBoolean(JAVA_AUTO_COMPLETION_SUBWORDS, false));
        this.javadocAutoCompletionTriggersField.setText(this.preferences.get(JAVADOC_AUTO_COMPLETION_TRIGGERS, JAVADOC_AUTO_COMPLETION_TRIGGERS_DEFAULT));
        this.javadocCompletionSelectorsField.setText(this.preferences.get(JAVADOC_COMPLETION_SELECTORS, JAVADOC_COMPLETION_SELECTORS_DEFAULT));
        String blacklist = this.preferences.get(JAVA_COMPLETION_BLACKLIST, "");
        this.initExcluderList(this.javaCompletionExcludeJlist, blacklist);
        String whitelist = this.preferences.get(JAVA_COMPLETION_WHITELIST, "");
        this.initExcluderList(this.javaCompletionIncludeJlist, whitelist);
        this.javaCompletionExcluderMethodsCheckBox.setSelected(this.preferences.getBoolean(JAVA_COMPLETION_EXCLUDER_METHODS, false));
        this.javaCompletionExcluderDialog2.getRootPane().setDefaultButton(this.javaCompletionExcluderDialogOkButton);
        this.id2Saved.put(GUESS_METHOD_ARGUMENTS, this.guessMethodArguments.isSelected());
        this.id2Saved.put(JAVA_AUTO_POPUP_ON_IDENTIFIER_PART, this.javaAutoPopupOnIdentifierPart.isSelected());
        this.id2Saved.put(JAVA_AUTO_COMPLETION_SUBWORDS, this.javaAutoCompletionSubwords.isSelected());
        this.id2Saved.put(JAVA_COMPLETION_EXCLUDER_METHODS, this.javaCompletionExcluderMethodsCheckBox.isSelected());
        this.id2Saved.put(JAVA_AUTO_COMPLETION_TRIGGERS, this.javaAutoCompletionTriggersField.getText());
        this.id2Saved.put(JAVA_COMPLETION_SELECTORS, this.javaCompletionSelectorsField.getText());
        this.id2Saved.put(JAVADOC_AUTO_COMPLETION_TRIGGERS, this.javadocAutoCompletionTriggersField.getText());
        this.id2Saved.put(JAVADOC_COMPLETION_SELECTORS, this.javadocCompletionSelectorsField.getText());
        this.id2Saved.put(JAVA_COMPLETION_BLACKLIST, blacklist);
        this.id2Saved.put(JAVA_COMPLETION_WHITELIST, whitelist);
        this.javaCompletionExcluderDialog2.pack();
        this.javaCompletionExcluderDialog2.setLocationRelativeTo(this);
        this.javaAutoCompletionTriggersField.getDocument().addDocumentListener(this);
        this.javaCompletionSelectorsField.getDocument().addDocumentListener(this);
        this.javadocAutoCompletionTriggersField.getDocument().addDocumentListener(this);
        this.javadocCompletionSelectorsField.getDocument().addDocumentListener(this);
    }

    private void initExcluderList(JList jList, String list) {
        String[] entries;
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String entry : entries = list.split(",")) {
            if (entry.length() == 0) continue;
            model.addElement(entry);
        }
        jList.setModel(model);
    }

    private void openExcluderEditor() {
        assert (!this.javaCompletionExcluderDialog2.isVisible());
        this.javaCompletionExcluderDialogTextField.setText(this.javaExcluderEditing);
        this.javaCompletionExcluderDialog2.setVisible(true);
        this.javaCompletionExcluderDialogTextField.requestFocus();
    }

    public static PreferencesCustomizer.Factory getCustomizerFactory() {
        return new PreferencesCustomizer.Factory(){

            @Override
            public PreferencesCustomizer create(Preferences preferences) {
                return new CodeCompletionPreferencesCustomizer(preferences);
            }
        };
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update(e);
    }

    private void initComponents() {
        this.javaCompletionExcluderDialog2 = new JDialog();
        this.javaCompletionExcluderDialogTextField = new JTextField();
        this.javaCompletionExcluderDialogOkButton = new JButton();
        this.javaCompletionExcluderDialogLabel = new JLabel();
        this.javaCompletionExcluderDialogCancelButton = new JButton();
        this.javaCompletionExcluderEditButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.javaCompletionExcluderAddButton = new JButton();
        this.javaCompletionExcluderRemoveButton = new JButton();
        this.javaAutoCompletionSubwords = new JCheckBox();
        this.javaCompletionExcluderMethodsCheckBox = new JCheckBox();
        this.javaCompletionExcluderTab = new JTabbedPane();
        this.javaCompletionExcludeScrollPane = new JScrollPane();
        this.javaCompletionExcludeJlist = new JList();
        this.javaCompletionIncludeScrollPane = new JScrollPane();
        this.javaCompletionIncludeJlist = new JList();
        this.javaCompletionExcluderLabel = new JLabel();
        this.guessMethodArguments = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.javadocAutoCompletionTriggersField = new JTextField();
        this.javaCompletionSelectorsLabel = new JLabel();
        this.javaAutoCompletionTriggersField = new JTextField();
        this.javaAutoCompletionTriggersLabel = new JLabel();
        this.javaAutoPopupOnIdentifierPart = new JCheckBox();
        this.javadocAutoCompletionTriggersLabel = new JLabel();
        this.javaCompletionSelectorsField = new JTextField();
        this.javadocCompletionSelectorsLabel = new JLabel();
        this.javadocCompletionSelectorsField = new JTextField();
        this.javaCompletionExcluderDialog2.setTitle(NbBundle.getMessage(CodeCompletionPanel.class, "ExcluderDialogTitle"));
        this.javaCompletionExcluderDialog2.setModal(true);
        this.javaCompletionExcluderDialogTextField.setText(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderDialogTextField.text"));
        this.javaCompletionExcluderDialogTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                CodeCompletionPanel.this.javaCompletionExcluderDialogTextFieldKeyTyped(evt);
            }
        });
        Mnemonics.setLocalizedText(this.javaCompletionExcluderDialogOkButton, NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderDialogOkButton.text"));
        this.javaCompletionExcluderDialogOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeCompletionPanel.this.javaCompletionExcluderDialogOkButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.javaCompletionExcluderDialogLabel, NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderDialogLabel.text"));
        Mnemonics.setLocalizedText(this.javaCompletionExcluderDialogCancelButton, NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderDialogCancelButton.text"));
        this.javaCompletionExcluderDialogCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeCompletionPanel.this.javaCompletionExcluderDialogCancelButtonActionPerformed(evt);
            }
        });
        GroupLayout javaCompletionExcluderDialog2Layout = new GroupLayout(this.javaCompletionExcluderDialog2.getContentPane());
        this.javaCompletionExcluderDialog2.getContentPane().setLayout(javaCompletionExcluderDialog2Layout);
        javaCompletionExcluderDialog2Layout.setHorizontalGroup(javaCompletionExcluderDialog2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(javaCompletionExcluderDialog2Layout.createSequentialGroup().addContainerGap().addGroup(javaCompletionExcluderDialog2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.javaCompletionExcluderDialogLabel, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.javaCompletionExcluderDialogTextField, GroupLayout.Alignment.LEADING, -1, 307, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(javaCompletionExcluderDialog2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.javaCompletionExcluderDialogOkButton, -1, -1, Short.MAX_VALUE).addComponent(this.javaCompletionExcluderDialogCancelButton, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        javaCompletionExcluderDialog2Layout.setVerticalGroup(javaCompletionExcluderDialog2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, javaCompletionExcluderDialog2Layout.createSequentialGroup().addGroup(javaCompletionExcluderDialog2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(javaCompletionExcluderDialog2Layout.createSequentialGroup().addContainerGap().addComponent(this.javaCompletionExcluderDialogLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(javaCompletionExcluderDialog2Layout.createSequentialGroup().addContainerGap().addComponent(this.javaCompletionExcluderDialogCancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(javaCompletionExcluderDialog2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaCompletionExcluderDialogTextField, -2, -1, -2).addComponent(this.javaCompletionExcluderDialogOkButton)).addGap(61, 61, 61)));
        this.javaCompletionExcluderDialogTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderDialogTextField.AccessibleContext.accessibleName"));
        this.javaCompletionExcluderDialogTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderDialogTextField.AccessibleContext.accessibleDescription"));
        this.javaCompletionExcluderDialogOkButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_OKButton"));
        this.javaCompletionExcluderDialogLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderDialogLabel.AccessibleContext.accessibleName"));
        this.javaCompletionExcluderDialogCancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_CancelButton"));
        this.javaCompletionExcluderDialog2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderDialog2.AccessibleContext.accessibleName"));
        this.javaCompletionExcluderDialog2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_PopupDialog"));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.javaCompletionExcluderEditButton.setMnemonic('E');
        Mnemonics.setLocalizedText(this.javaCompletionExcluderEditButton, NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderEditButton.text"));
        this.javaCompletionExcluderEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeCompletionPanel.this.javaCompletionExcluderEditButtonActionPerformed(evt);
            }
        });
        this.javaCompletionExcluderAddButton.setMnemonic('A');
        Mnemonics.setLocalizedText(this.javaCompletionExcluderAddButton, NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderAddButton.text"));
        this.javaCompletionExcluderAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeCompletionPanel.this.javaCompletionExcluderAddButtonActionPerformed(evt);
            }
        });
        this.javaCompletionExcluderRemoveButton.setMnemonic('R');
        Mnemonics.setLocalizedText(this.javaCompletionExcluderRemoveButton, NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderRemoveButton.text"));
        this.javaCompletionExcluderRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeCompletionPanel.this.javaCompletionExcluderRemoveButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.javaAutoCompletionSubwords, NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaAutoCompletionSubwords.text"));
        this.javaAutoCompletionSubwords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeCompletionPanel.this.javaAutoCompletionSubwordsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.javaCompletionExcluderMethodsCheckBox, NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderMethodsCheckBox.text"));
        this.javaCompletionExcluderMethodsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeCompletionPanel.this.javaCompletionExcluderMethodsCheckBoxActionPerformed(evt);
            }
        });
        this.javaCompletionExcludeScrollPane.setViewportView(this.javaCompletionExcludeJlist);
        this.javaCompletionExcludeJlist.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcludeJlist.AccessibleContext.accessibleName"));
        this.javaCompletionExcludeJlist.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_ExcludeList"));
        this.javaCompletionExcluderTab.addTab(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcludeScrollPane.TabConstraints.tabTitle"), this.javaCompletionExcludeScrollPane);
        this.javaCompletionExcludeScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcludeScrollPane.AccessibleContext.accessibleName"));
        this.javaCompletionIncludeScrollPane.setViewportView(this.javaCompletionIncludeJlist);
        this.javaCompletionIncludeJlist.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionIncludeJlist.AccessibleContext.accessibleName"));
        this.javaCompletionIncludeJlist.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_LT_Include"));
        this.javaCompletionExcluderTab.addTab(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionIncludeScrollPane.TabConstraints.tabTitle"), this.javaCompletionIncludeScrollPane);
        this.javaCompletionIncludeScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionIncludeScrollPane.AccessibleContext.accessibleName"));
        this.javaCompletionExcluderLabel.setLabelFor(this.javaCompletionExcluderTab);
        Mnemonics.setLocalizedText(this.javaCompletionExcluderLabel, NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderLabel.text"));
        Mnemonics.setLocalizedText(this.guessMethodArguments, NbBundle.getMessage(CodeCompletionPanel.class, "LBL_GuessMethodArgs"));
        this.guessMethodArguments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeCompletionPanel.this.guessMethodArgumentsActionPerformed(evt);
            }
        });
        this.javadocAutoCompletionTriggersField.setText(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javadocAutoCompletionTriggersField.text"));
        this.javaCompletionSelectorsLabel.setLabelFor(this.javaCompletionSelectorsField);
        Mnemonics.setLocalizedText(this.javaCompletionSelectorsLabel, NbBundle.getMessage(CodeCompletionPanel.class, "LBL_JavaCompletionSelectors"));
        this.javaAutoCompletionTriggersField.setAlignmentX(1.0f);
        this.javaAutoCompletionTriggersLabel.setLabelFor(this.javaAutoCompletionTriggersField);
        Mnemonics.setLocalizedText(this.javaAutoCompletionTriggersLabel, NbBundle.getMessage(CodeCompletionPanel.class, "LBL_JavaAutoCompletionTriggers"));
        Mnemonics.setLocalizedText(this.javaAutoPopupOnIdentifierPart, NbBundle.getMessage(CodeCompletionPanel.class, "LBL_AutoPopupOnIdentifierPartBox"));
        this.javaAutoPopupOnIdentifierPart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeCompletionPanel.this.javaAutoPopupOnIdentifierPartActionPerformed(evt);
            }
        });
        this.javadocAutoCompletionTriggersLabel.setLabelFor(this.javadocAutoCompletionTriggersField);
        Mnemonics.setLocalizedText(this.javadocAutoCompletionTriggersLabel, NbBundle.getMessage(CodeCompletionPanel.class, "LBL_JavadocAutoCompletionTriggers"));
        this.javadocCompletionSelectorsLabel.setLabelFor(this.javadocCompletionSelectorsField);
        Mnemonics.setLocalizedText(this.javadocCompletionSelectorsLabel, NbBundle.getMessage(CodeCompletionPanel.class, "LBL_JavadocCompletionSelectors"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.jSeparator2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.guessMethodArguments).addComponent(this.javaAutoPopupOnIdentifierPart).addComponent(this.javaCompletionExcluderMethodsCheckBox).addComponent(this.javaCompletionExcluderLabel).addGroup(layout.createSequentialGroup().addComponent(this.javaCompletionSelectorsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.javaCompletionSelectorsField, -2, 86, -2)).addGroup(layout.createSequentialGroup().addComponent(this.javaAutoCompletionTriggersLabel).addGap(46, 46, 46).addComponent(this.javaAutoCompletionTriggersField, -2, 86, -2)).addComponent(this.javaAutoCompletionSubwords).addComponent(this.javaCompletionExcluderTab).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javadocAutoCompletionTriggersLabel).addComponent(this.javadocCompletionSelectorsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.javadocAutoCompletionTriggersField, -1, 86, Short.MAX_VALUE).addComponent(this.javadocCompletionSelectorsField)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaCompletionExcluderRemoveButton).addComponent(this.javaCompletionExcluderEditButton).addComponent(this.javaCompletionExcluderAddButton)))).addContainerGap()));
        layout.linkSize(0, this.javaCompletionExcluderAddButton, this.javaCompletionExcluderEditButton, this.javaCompletionExcluderRemoveButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.guessMethodArguments, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaAutoCompletionTriggersLabel).addComponent(this.javaAutoCompletionTriggersField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javaAutoPopupOnIdentifierPart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaCompletionSelectorsLabel).addComponent(this.javaCompletionSelectorsField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javaAutoCompletionSubwords).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 4, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javaCompletionExcluderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.javaCompletionExcluderTab, -2, 124, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.javaCompletionExcluderAddButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javaCompletionExcluderRemoveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javaCompletionExcluderEditButton).addGap(19, 19, 19))).addComponent(this.javaCompletionExcluderMethodsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 4, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javadocAutoCompletionTriggersLabel).addComponent(this.javadocAutoCompletionTriggersField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javadocCompletionSelectorsLabel).addComponent(this.javadocCompletionSelectorsField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.javaCompletionExcluderEditButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_Edit"));
        this.javaCompletionExcluderAddButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_Add"));
        this.javaCompletionExcluderRemoveButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_Remove"));
        this.javaCompletionExcluderMethodsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "ACSN_CB_ApplyRulesToMethods"));
        this.javaCompletionExcluderMethodsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_MethodsCB"));
        this.javaCompletionExcluderTab.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "CodeCompletionPanel.javaCompletionExcluderTab.AccessibleContext.accessibleName"));
        this.javaCompletionExcluderTab.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_Table"));
        this.guessMethodArguments.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "ACSN_CB_GuessMethodArgs"));
        this.guessMethodArguments.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_CB_GuessMethodArgs"));
        this.javadocAutoCompletionTriggersField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "ACSN_JavadocTriggers"));
        this.javadocAutoCompletionTriggersField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_JavadocTrigger"));
        this.javaCompletionSelectorsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "ACSN_JavaCompletionSelectors"));
        this.javaCompletionSelectorsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_JavaCompletionSelectors"));
        this.javaAutoCompletionTriggersLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "ACSN_JavaTriggers"));
        this.javaAutoCompletionTriggersLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_JavaTrigger"));
        this.javaAutoPopupOnIdentifierPart.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "ACSN_CB_AutoPopupOnIdentifierPartBox"));
        this.javaAutoPopupOnIdentifierPart.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_CB_AutoPopupOnIdentifierPartBox"));
        this.javadocAutoCompletionTriggersLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "ACSN_JavadocTriggers"));
        this.javadocAutoCompletionTriggersLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_JavadocTrigger"));
        this.javaCompletionSelectorsField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, "ACSN_JavaCompletionSelectors"));
        this.javaCompletionSelectorsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, "ACSD_JavaCompletionSelectors"));
    }

    private void javaCompletionExcluderDialogOkButtonActionPerformed(ActionEvent evt) {
        String[] entries;
        JList list = this.getSelectedExcluderList();
        String text = this.javaCompletionExcluderDialogTextField.getText();
        DefaultListModel model = (DefaultListModel)list.getModel();
        int index = model.size();
        if (this.javaExcluderEditing != null) {
            index = model.indexOf(this.javaExcluderEditing);
            model.remove(index);
            this.javaExcluderEditing = null;
        }
        for (String entry : entries = text.split(",")) {
            entry = entry.replace("\u200b", "");
            if ((entry = entry.trim()).length() == 0 || !entry.matches(JAVA_FQN_REGEX)) continue;
            model.insertElementAt(entry, index);
            ++index;
        }
        this.updateExcluder(list);
        this.javaCompletionExcluderDialog2.setVisible(false);
        this.javaCompletionExcluderDialogTextField.setText(null);
    }

    private void javaCompletionExcluderDialogCancelButtonActionPerformed(ActionEvent evt) {
        this.javaCompletionExcluderDialog2.setVisible(false);
        this.javaCompletionExcluderDialogTextField.setText(null);
        this.javaExcluderEditing = null;
    }

    private void javaCompletionExcluderDialogTextFieldKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (c != ' ' && c != ',' && c != '*' && !String.valueOf(c).matches(JAVA_FQN_REGEX) && c != '\b') {
            this.getToolkit().beep();
            evt.consume();
        }
    }

    private void javaAutoCompletionSubwordsActionPerformed(ActionEvent evt) {
        this.preferences.putBoolean(JAVA_AUTO_COMPLETION_SUBWORDS, this.javaAutoCompletionSubwords.isSelected());
    }

    private void javaCompletionExcluderEditButtonActionPerformed(ActionEvent evt) {
        JList list = this.getSelectedExcluderList();
        int index = list.getSelectedIndex();
        if (index == -1) {
            return;
        }
        DefaultListModel model = (DefaultListModel)list.getModel();
        this.javaExcluderEditing = (String)model.getElementAt(index);
        this.openExcluderEditor();
    }

    private void javaCompletionExcluderRemoveButtonActionPerformed(ActionEvent evt) {
        JList list = this.getSelectedExcluderList();
        int[] rows = list.getSelectedIndices();
        DefaultListModel model = (DefaultListModel)list.getModel();
        for (int row = rows.length - 1; row >= 0; --row) {
            model.remove(rows[row]);
        }
        this.updateExcluder(list);
    }

    private void javaCompletionExcluderAddButtonActionPerformed(ActionEvent evt) {
        this.openExcluderEditor();
    }

    private void javaCompletionExcluderMethodsCheckBoxActionPerformed(ActionEvent evt) {
        this.preferences.putBoolean(JAVA_COMPLETION_EXCLUDER_METHODS, this.javaCompletionExcluderMethodsCheckBox.isSelected());
    }

    private void javaAutoPopupOnIdentifierPartActionPerformed(ActionEvent evt) {
        this.preferences.putBoolean(JAVA_AUTO_POPUP_ON_IDENTIFIER_PART, this.javaAutoPopupOnIdentifierPart.isSelected());
    }

    private void guessMethodArgumentsActionPerformed(ActionEvent evt) {
        this.preferences.putBoolean(GUESS_METHOD_ARGUMENTS, this.guessMethodArguments.isSelected());
    }

    private void update(DocumentEvent e) {
        if (e.getDocument() == this.javaAutoCompletionTriggersField.getDocument()) {
            this.preferences.put(JAVA_AUTO_COMPLETION_TRIGGERS, this.javaAutoCompletionTriggersField.getText());
        } else if (e.getDocument() == this.javaCompletionSelectorsField.getDocument()) {
            this.preferences.put(JAVA_COMPLETION_SELECTORS, this.javaCompletionSelectorsField.getText());
        } else if (e.getDocument() == this.javadocAutoCompletionTriggersField.getDocument()) {
            this.preferences.put(JAVADOC_AUTO_COMPLETION_TRIGGERS, this.javadocAutoCompletionTriggersField.getText());
        } else if (e.getDocument() == this.javadocCompletionSelectorsField.getDocument()) {
            this.preferences.put(JAVADOC_COMPLETION_SELECTORS, this.javadocCompletionSelectorsField.getText());
        }
    }

    private void updateExcluder(JList list) {
        String pref;
        DefaultListModel model = (DefaultListModel)list.getModel();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < model.size(); ++i) {
            String entry = (String)model.getElementAt(i);
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(entry);
        }
        if (list == this.javaCompletionExcludeJlist) {
            pref = JAVA_COMPLETION_BLACKLIST;
        } else if (list == this.javaCompletionIncludeJlist) {
            pref = JAVA_COMPLETION_WHITELIST;
        } else {
            throw new RuntimeException(list.getName());
        }
        this.preferences.put(pref, builder.toString());
    }

    private JList getSelectedExcluderList() {
        Component selected = this.javaCompletionExcluderTab.getSelectedComponent();
        if (selected == this.javaCompletionExcludeScrollPane) {
            return this.javaCompletionExcludeJlist;
        }
        if (selected == this.javaCompletionIncludeScrollPane) {
            return this.javaCompletionIncludeJlist;
        }
        throw new RuntimeException(selected.getName());
    }

    String getSavedValue(String key) {
        return this.id2Saved.get(key).toString();
    }

    public static final class CustomCustomizerImpl
    extends PreferencesCustomizer.CustomCustomizer {
        @Override
        public String getSavedValue(PreferencesCustomizer customCustomizer, String key) {
            if (customCustomizer instanceof CodeCompletionPreferencesCustomizer) {
                return ((CodeCompletionPanel)customCustomizer.getComponent()).getSavedValue(key);
            }
            return null;
        }
    }

    private static class CodeCompletionPreferencesCustomizer
    implements PreferencesCustomizer {
        private final Preferences preferences;
        private CodeCompletionPanel component;

        private CodeCompletionPreferencesCustomizer(Preferences p) {
            this.preferences = p;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public HelpCtx getHelpCtx() {
            return new HelpCtx("netbeans.optionsDialog.editor.codeCompletion.java");
        }

        @Override
        public JComponent getComponent() {
            if (this.component == null) {
                this.component = new CodeCompletionPanel(this.preferences);
            }
            return this.component;
        }
    }
}

