/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.LocaleVariants;
import org.netbeans.Module;
import org.netbeans.ModuleData;
import org.netbeans.ModuleManager;
import org.netbeans.ProxyClassLoader;
import org.netbeans.StandardModuleData;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class StandardModule
extends Module {
    private final File jar;
    private File physicalJar;
    private Manifest manifest;
    private static final Set<File> moduleJARs = new HashSet<File>();
    private Set<File> patches;
    private Properties localizedProps;
    private static PermissionCollection modulePermissions;
    private static final Logger CL_LOG;

    public StandardModule(ModuleManager mgr, Events ev, File jar, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException {
        super(mgr, ev, history, reloadable, autoload, eager);
        this.jar = jar;
        moduleJARs.add(jar);
    }

    @Override
    ModuleData createData(ObjectInput in, Manifest mf) throws IOException {
        if (in != null) {
            return new StandardModuleData(in);
        }
        return new StandardModuleData(mf, this);
    }

    @Override
    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                this.loadManifest();
            }
            catch (IOException x) {
                Util.err.log(Level.WARNING, "While loading manifest for " + this.getJarFile(), x);
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    @Override
    public void releaseManifest() {
        this.manifest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getLocalizedAttribute(String attr) {
        int idx;
        String locb = this.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        boolean usingLoader = false;
        if (locb != null) {
            if (this.classloader != null) {
                if (locb.endsWith(".properties")) {
                    usingLoader = true;
                    String basename = locb.substring(0, locb.length() - 11).replace('/', '.');
                    try {
                        ResourceBundle bundle = NbBundle.getBundle(basename, Locale.getDefault(), this.classloader);
                        try {
                            return bundle.getString(attr);
                        }
                        catch (MissingResourceException missingResourceException) {
                        }
                    }
                    catch (MissingResourceException mre) {
                        String resource = basename.replace('.', '/') + ".properties";
                        Exceptions.attachMessage(mre, "#149833: failed to find " + basename + " in locale " + Locale.getDefault() + " in " + this.classloader + " for " + this.jar + "; resource lookup of " + resource + " -> " + this.classloader.getResource(resource));
                        Exceptions.printStackTrace(mre);
                    }
                } else {
                    Util.err.warning("cannot efficiently load non-*.properties OpenIDE-Module-Localizing-Bundle: " + locb);
                }
            }
            if (!usingLoader) {
                String val;
                block19: {
                    if (this.localizedProps == null) {
                        Util.err.log(Level.FINE, "Trying to get localized attr {0} from disabled module {1}", new Object[]{attr, this.getCodeNameBase()});
                        try {
                            if (this.jar != null && this.jar.isFile()) {
                                try (JarFile jarFile = new JarFile(this.jar, false);){
                                    this.loadLocalizedProps(jarFile, this.getManifest());
                                    break block19;
                                }
                            }
                            Util.err.log(Level.FINE, "Cannot get localized attr {0} from module {1} (missing or deleted JAR file: {2})", new Object[]{attr, this.getCodeNameBase(), this.jar});
                        }
                        catch (IOException ioe) {
                            Util.err.log(Level.WARNING, this.jar.getAbsolutePath(), ioe);
                        }
                    }
                }
                if (this.localizedProps != null && (val = this.localizedProps.getProperty(attr)) != null) {
                    return val;
                }
            }
        }
        if ((idx = attr.lastIndexOf(47)) == -1) {
            return NbBundle.getLocalizedValue(this.getManifest().getMainAttributes(), new Attributes.Name(attr));
        }
        String section = attr.substring(0, idx);
        String realAttr = attr.substring(idx + 1);
        Attributes attrs = this.getManifest().getAttributes(section);
        if (attrs != null) {
            return NbBundle.getLocalizedValue(attrs, new Attributes.Name(realAttr));
        }
        return null;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public File getJarFile() {
        return this.jar;
    }

    private void ensurePhysicalJar() throws IOException {
        if (this.reloadable && this.physicalJar == null) {
            this.physicalJar = Util.makeTempJar(this.jar);
        }
    }

    private void destroyPhysicalJar() {
        if (this.physicalJar != null) {
            if (this.physicalJar.isFile()) {
                if (!this.physicalJar.delete()) {
                    Util.err.warning("temporary JAR " + this.physicalJar + " not currently deletable.");
                } else {
                    Util.err.fine("deleted: " + this.physicalJar);
                }
            }
            this.physicalJar = null;
        } else {
            Util.err.fine("no physicalJar to delete for " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest() throws IOException {
        block9: {
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.fine("loading manifest of " + this.jar);
            }
            File jarBeingOpened = null;
            try {
                if (this.reloadable) {
                    jarBeingOpened = this.physicalJar;
                    this.ensurePhysicalJar();
                    jarBeingOpened = this.physicalJar;
                    try (JarFile jarFile = new JarFile(this.physicalJar, false);){
                        Manifest m = jarFile.getManifest();
                        if (m == null) {
                            throw new IOException("No manifest found in " + this.physicalJar);
                        }
                        this.manifest = m;
                        break block9;
                    }
                }
                jarBeingOpened = this.jar;
                this.manifest = this.getManager().loadManifest(this.jar);
            }
            catch (IOException e) {
                if (jarBeingOpened != null) {
                    Exceptions.attachMessage(e, "While loading manifest from: " + jarBeingOpened);
                }
                throw e;
            }
        }
    }

    private Set<File> findPatches() {
        if (this.patches == null) {
            String patchesClassPath;
            File patchdir = new File(new File(this.jar.getParentFile(), "patches"), this.getCodeNameBase().replace('.', '-'));
            if (patchdir.isDirectory()) {
                File[] jars = patchdir.listFiles(Util.jarFilter());
                if (jars != null) {
                    for (File patchJar : jars) {
                        if (this.patches == null) {
                            this.patches = new HashSet<File>(5);
                        }
                        this.patches.add(patchJar);
                    }
                } else {
                    Util.err.warning("Could not search for patches in " + patchdir);
                }
            }
            if ((patchesClassPath = System.getProperty("netbeans.patches." + this.getCodeNameBase())) != null) {
                StringTokenizer tokenizer = new StringTokenizer(patchesClassPath, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String element = tokenizer.nextToken();
                    File fileElement = new File(element);
                    if (!fileElement.exists()) continue;
                    if (this.patches == null) {
                        this.patches = new HashSet<File>(15);
                    }
                    this.patches.add(fileElement);
                }
            }
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.log(Level.FINE, "patches of {0}: {1}", new Object[]{this.jar, this.patches});
            }
            if (this.patches != null) {
                for (File patch : this.patches) {
                    this.events.log("patch", patch);
                }
            }
            if (this.patches == null) {
                this.patches = Collections.emptySet();
            }
        }
        return this.patches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedProps(JarFile jarFile, Manifest m) throws IOException {
        String locbundle = m.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        if (locbundle != null) {
            String ext;
            String name;
            int idx;
            ZipEntry bundleFile = jarFile.getEntry(locbundle);
            if (bundleFile != null) {
                this.localizedProps = new Properties();
                try (InputStream is = jarFile.getInputStream(bundleFile);){
                    this.localizedProps.load(is);
                }
            }
            if ((idx = locbundle.lastIndexOf(46)) == -1) {
                name = locbundle;
                ext = "";
            } else {
                name = locbundle.substring(0, idx);
                ext = locbundle.substring(idx);
            }
            List<LocaleVariants.FileWithSuffix> pairs = LocaleVariants.findLocaleVariantsWithSuffixesOf(this.jar, this.getCodeNameBase());
            Collections.reverse(pairs);
            for (LocaleVariants.FileWithSuffix pair : pairs) {
                File localeJar = pair.file;
                String suffix = pair.suffix;
                String rsrc = name + suffix + ext;
                try (JarFile localeJarFile = new JarFile(localeJar, false);){
                    ZipEntry bundleFile2 = localeJarFile.getEntry(rsrc);
                    if (bundleFile2 == null) continue;
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    try (InputStream is = localeJarFile.getInputStream(bundleFile2);){
                        this.localizedProps.load(is);
                    }
                }
            }
            if (this.localizedProps == null) {
                throw new IOException("Could not find localizing bundle: " + locbundle);
            }
        }
    }

    @Override
    public List<File> getAllJars() {
        ArrayList<File> l = new ArrayList<File>();
        Set<File> ptchs = this.findPatches();
        if (ptchs != null) {
            l.addAll(ptchs);
        }
        if (this.physicalJar != null) {
            l.add(this.physicalJar);
        } else if (this.jar != null) {
            l.add(this.jar);
        }
        ((StandardModuleData)this.data()).addCp(l);
        return l;
    }

    @Override
    public void setReloadable(boolean r) {
        this.getManager().assertWritable();
        if (this.reloadable != r) {
            this.reloadable = r;
            this.getManager().fireReloadable(this);
        }
    }

    @Override
    public void reload() throws IOException {
        this.destroyPhysicalJar();
        String codeNameBase1 = this.getCodeNameBase();
        this.localizedProps = null;
        this.loadManifest();
        this.parseManifest();
        String codeNameBase2 = this.getCodeNameBase();
        if (!codeNameBase1.equals(codeNameBase2)) {
            throw new InvalidException("Code name base changed during reload: " + codeNameBase1 + " -> " + codeNameBase2);
        }
    }

    @Override
    protected void classLoaderUp(Set<Module> parents) throws IOException {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("classLoaderUp on " + this + " with parents " + parents);
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(parents.size() + 1);
        loaders.add(Module.class.getClassLoader());
        for (Module parent : parents) {
            Module.PackageExport[] exports = parent.getPublicPackages();
            if (exports != null && exports.length == 0) {
                boolean implDep = false;
                for (Dependency dep : this.getDependenciesArray()) {
                    if (dep.getType() != 1 || dep.getComparison() != 2 || !dep.getName().equals(parent.getCodeName())) continue;
                    implDep = true;
                    break;
                }
                if (!implDep) continue;
            }
            ClassLoader l = this.getParentLoader(parent);
            if (parent.isFixed() && loaders.contains(l)) {
                Util.err.log(Level.FINE, "#24996: skipping duplicate classloader from {0}", parent);
                continue;
            }
            loaders.add(l);
        }
        ArrayList<File> classp = new ArrayList<File>(3);
        Set<File> ptchs = this.findPatches();
        if (ptchs != null) {
            classp.addAll(ptchs);
        }
        if (this.reloadable) {
            this.ensurePhysicalJar();
            classp.add(this.physicalJar);
        } else {
            classp.add(this.jar);
        }
        ((StandardModuleData)this.data()).addCp(classp);
        this.getManager().refineModulePath(this, classp);
        ClassLoader cld = this.getManager().refineClassLoader(this, loaders);
        if (cld != null) {
            this.classloader = cld;
        } else {
            try {
                this.classloader = this.createNewClassLoader(classp, loaders);
            }
            catch (IllegalArgumentException iae) {
                throw (IOException)new IOException(iae.toString()).initCause(iae);
            }
        }
    }

    protected ClassLoader createNewClassLoader(List<File> classp, List<ClassLoader> parents) {
        return new OneModuleClassLoader(classp, parents.toArray(new ClassLoader[0]));
    }

    protected ClassLoader getParentLoader(Module parent) {
        return parent.getClassLoader();
    }

    @Override
    protected void classLoaderDown() {
        if (this.classloader instanceof ProxyClassLoader) {
            ((ProxyClassLoader)this.classloader).destroy();
        }
        this.classloader = null;
    }

    @Override
    protected void cleanup() {
        if (this.isEnabled()) {
            throw new IllegalStateException("cleanup on enabled module: " + this);
        }
        if (this.classloader != null) {
            throw new IllegalStateException("cleanup on module with classloader: " + this);
        }
        this.destroyPhysicalJar();
    }

    @Override
    public void destroy() {
        moduleJARs.remove(this.jar);
    }

    @Override
    public String toString() {
        String s = "StandardModule:" + this.getCodeNameBase() + " jarFile: " + this.jar.getAbsolutePath();
        if (!this.isValid()) {
            s = s + "[invalid]";
        }
        return s;
    }

    private static synchronized PermissionCollection getAllPermission() {
        if (modulePermissions == null) {
            modulePermissions = new Permissions();
            modulePermissions.add(new AllPermission());
            modulePermissions.setReadOnly();
        }
        return modulePermissions;
    }

    static boolean isModuleJar(File f) {
        return moduleJARs.contains(f);
    }

    static {
        CL_LOG = Logger.getLogger(OneModuleClassLoader.class.getName());
    }

    class OneModuleClassLoader
    extends JarClassLoader
    implements Util.ModuleProvider {
        public OneModuleClassLoader(List<File> classp, ClassLoader[] parents) throws IllegalArgumentException {
            super(classp, parents, false, StandardModule.this);
        }

        @Override
        public Module getModule() {
            return StandardModule.this;
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource cs) {
            return StandardModule.getAllPermission();
        }

        @Override
        protected String findLibrary(String libname) {
            InstalledFileLocator ifl = InstalledFileLocator.getDefault();
            String arch = System.getProperty("os.arch");
            String system = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            String mapped = System.mapLibraryName(libname);
            File lib = ifl.locate("modules/lib/" + mapped, StandardModule.this.getCodeNameBase(), false);
            if (lib != null) {
                CL_LOG.log(Level.FINE, "found {0}", lib);
                return lib.getAbsolutePath();
            }
            lib = ifl.locate("modules/lib/" + arch + "/" + mapped, StandardModule.this.getCodeNameBase(), false);
            if (lib != null) {
                CL_LOG.log(Level.FINE, "found {0}", lib);
                return lib.getAbsolutePath();
            }
            lib = ifl.locate("modules/lib/" + arch + "/" + system + "/" + mapped, StandardModule.this.getCodeNameBase(), false);
            if (lib != null) {
                CL_LOG.log(Level.FINE, "found {0}", lib);
                return lib.getAbsolutePath();
            }
            if (BaseUtilities.isMac()) {
                String jniMapped = mapped.replaceFirst("\\.dylib$", ".jnilib");
                lib = ifl.locate("modules/lib/" + jniMapped, StandardModule.this.getCodeNameBase(), false);
                if (lib != null) {
                    CL_LOG.log(Level.FINE, "found {0}", lib);
                    return lib.getAbsolutePath();
                }
                lib = ifl.locate("modules/lib/" + arch + "/" + jniMapped, StandardModule.this.getCodeNameBase(), false);
                if (lib != null) {
                    CL_LOG.log(Level.FINE, "found {0}", lib);
                    return lib.getAbsolutePath();
                }
                lib = ifl.locate("modules/lib/" + arch + "/" + system + "/" + jniMapped, StandardModule.this.getCodeNameBase(), false);
                if (lib != null) {
                    CL_LOG.log(Level.FINE, "found {0}", lib);
                    return lib.getAbsolutePath();
                }
                CL_LOG.log(Level.FINE, "found nothing like modules/lib/{0}/{1}/{2}", new Object[]{arch, system, jniMapped});
            }
            CL_LOG.log(Level.FINE, "found nothing like modules/lib/{0}/{1}/{2}", new Object[]{arch, system, mapped});
            return null;
        }

        @Override
        protected boolean shouldDelegateResource(String pkg, ClassLoader parent) {
            if (!super.shouldDelegateResource(pkg, parent)) {
                return false;
            }
            Module other = parent instanceof Util.ModuleProvider ? ((Util.ModuleProvider)((Object)parent)).getModule() : null;
            return StandardModule.this.getManager().shouldDelegateResource(StandardModule.this, other, pkg, parent);
        }

        public String toString() {
            return "ModuleCL@" + Integer.toHexString(System.identityHashCode(this)) + "[" + StandardModule.this.getCodeNameBase() + "]";
        }
    }
}

