/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class MailingList
implements Serializable,
InputLocationTracker {
    final String name;
    final String subscribe;
    final String unsubscribe;
    final String post;
    final String archive;
    final List<String> otherArchives;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected MailingList(Builder builder) {
        String string = builder.name != null ? builder.name : (this.name = builder.base != null ? builder.base.name : null);
        String string2 = builder.subscribe != null ? builder.subscribe : (this.subscribe = builder.base != null ? builder.base.subscribe : null);
        String string3 = builder.unsubscribe != null ? builder.unsubscribe : (this.unsubscribe = builder.base != null ? builder.base.unsubscribe : null);
        String string4 = builder.post != null ? builder.post : (this.post = builder.base != null ? builder.base.post : null);
        String string5 = builder.archive != null ? builder.archive : (this.archive = builder.base != null ? builder.base.archive : null);
        this.otherArchives = ImmutableCollections.copy(builder.otherArchives != null ? builder.otherArchives : (builder.base != null ? builder.base.otherArchives : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getName() {
        return this.name;
    }

    public String getSubscribe() {
        return this.subscribe;
    }

    public String getUnsubscribe() {
        return this.unsubscribe;
    }

    public String getPost() {
        return this.post;
    }

    public String getArchive() {
        return this.archive;
    }

    @Nonnull
    public List<String> getOtherArchives() {
        return this.otherArchives;
    }

    @Override
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return MailingList.newBuilder(this);
    }

    @Nonnull
    public MailingList withName(String name) {
        return MailingList.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public MailingList withSubscribe(String subscribe) {
        return MailingList.newBuilder(this, true).subscribe(subscribe).build();
    }

    @Nonnull
    public MailingList withUnsubscribe(String unsubscribe) {
        return MailingList.newBuilder(this, true).unsubscribe(unsubscribe).build();
    }

    @Nonnull
    public MailingList withPost(String post) {
        return MailingList.newBuilder(this, true).post(post).build();
    }

    @Nonnull
    public MailingList withArchive(String archive) {
        return MailingList.newBuilder(this, true).archive(archive).build();
    }

    @Nonnull
    public MailingList withOtherArchives(Collection<String> otherArchives) {
        return MailingList.newBuilder(this, true).otherArchives(otherArchives).build();
    }

    @Nonnull
    public static MailingList newInstance() {
        return MailingList.newInstance(true);
    }

    @Nonnull
    public static MailingList newInstance(boolean withDefaults) {
        return MailingList.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return MailingList.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(MailingList from) {
        return MailingList.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(MailingList from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return "MailingList {name=" + this.getName() + ", archive=" + this.getArchive() + "}";
    }

    @NotThreadSafe
    public static class Builder {
        MailingList base;
        String name;
        String subscribe;
        String unsubscribe;
        String post;
        String archive;
        Collection<String> otherArchives;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(MailingList base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.subscribe = base.subscribe;
                this.unsubscribe = base.unsubscribe;
                this.post = base.post;
                this.archive = base.archive;
                this.otherArchives = base.otherArchives;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder subscribe(String subscribe) {
            this.subscribe = subscribe;
            return this;
        }

        @Nonnull
        public Builder unsubscribe(String unsubscribe) {
            this.unsubscribe = unsubscribe;
            return this;
        }

        @Nonnull
        public Builder post(String post) {
            this.post = post;
            return this;
        }

        @Nonnull
        public Builder archive(String archive) {
            this.archive = archive;
            return this;
        }

        @Nonnull
        public Builder otherArchives(Collection<String> otherArchives) {
            this.otherArchives = otherArchives;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public MailingList build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.subscribe != null && this.subscribe != this.base.subscribe || this.unsubscribe != null && this.unsubscribe != this.base.unsubscribe || this.post != null && this.post != this.base.post || this.archive != null && this.archive != this.base.archive || this.otherArchives != null && this.otherArchives != this.base.otherArchives)) {
                return this.base;
            }
            return new MailingList(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

