/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.SessionScoped;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.impl.resolver.MavenWorkspaceReader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="reactor")
@SessionScoped
class ReactorReader
implements MavenWorkspaceReader {
    public static final String HINT = "reactor";
    public static final String PROJECT_LOCAL_REPO = "project-local-repo";
    private static final Collection<String> COMPILE_PHASE_TYPES = new HashSet<String>(Arrays.asList("jar", "ejb-client", "war", "rar", "ejb", "par", "sar", "wsr", "har", "app-client"));
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactorReader.class);
    private final MavenSession session;
    private final WorkspaceRepository repository;
    private Map<String, Map<String, Map<String, MavenProject>>> projects;
    private Map<String, Map<String, Map<String, MavenProject>>> allProjects;
    private Path projectLocalRepository;
    private final Map<String, Deque<String>> lifecycles = new ConcurrentHashMap<String, Deque<String>>();

    @Inject
    ReactorReader(MavenSession session) {
        this.session = session;
        this.repository = new WorkspaceRepository(HINT, null);
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public File findArtifact(Artifact artifact) {
        MavenProject project = this.getProject(artifact);
        if (project != null) {
            File file = this.findArtifact(project, artifact, true);
            if (file == null && project != project.getExecutionProject()) {
                file = this.findArtifact(project.getExecutionProject(), artifact, true);
            }
            return file;
        }
        File packagedArtifactFile = this.findInProjectLocalRepository(artifact);
        if (packagedArtifactFile != null && packagedArtifactFile.exists()) {
            if (!"pom".equals(artifact.getExtension()) && (project = this.getProject(artifact, this.getAllProjects())) != null) {
                this.isPackagedArtifactUpToDate(project, packagedArtifactFile);
            }
            return packagedArtifactFile;
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        List versions = this.getProjects().getOrDefault(artifact.getGroupId(), Collections.emptyMap()).getOrDefault(artifact.getArtifactId(), Collections.emptyMap()).values().stream().map(MavenProject::getVersion).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        if (!versions.isEmpty()) {
            return versions;
        }
        return this.getAllProjects().getOrDefault(artifact.getGroupId(), Collections.emptyMap()).getOrDefault(artifact.getArtifactId(), Collections.emptyMap()).values().stream().filter(p -> Objects.nonNull(this.findArtifact((MavenProject)p, artifact, false))).map(MavenProject::getVersion).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public Model findModel(Artifact artifact) {
        MavenProject project = this.getProject(artifact);
        return project == null ? null : project.getModel().getDelegate();
    }

    private File findArtifact(MavenProject project, Artifact artifact, boolean checkUptodate) {
        File packagedArtifactFile;
        if ("pom".equals(artifact.getExtension())) {
            return project.getFile();
        }
        Artifact projectArtifact = this.findMatchingArtifact(project, artifact);
        if (projectArtifact != null && (packagedArtifactFile = projectArtifact.getFile()) != null && packagedArtifactFile.exists()) {
            return packagedArtifactFile;
        }
        packagedArtifactFile = this.findInProjectLocalRepository(artifact);
        if (packagedArtifactFile != null && packagedArtifactFile.exists() && (!checkUptodate || "pom".equals(artifact.getExtension()) || this.isPackagedArtifactUpToDate(project, packagedArtifactFile))) {
            return packagedArtifactFile;
        }
        if (!this.hasBeenPackagedDuringThisSession(project)) {
            return this.determineBuildOutputDirectoryForArtifact(project, artifact);
        }
        return null;
    }

    private File determineBuildOutputDirectoryForArtifact(MavenProject project, Artifact artifact) {
        if (ReactorReader.isTestArtifact(artifact)) {
            if (project.hasLifecyclePhase("test-compile")) {
                return new File(project.getBuild().getTestOutputDirectory());
            }
        } else {
            boolean projectHasOutputFromPreviousSession;
            String type = artifact.getProperty("type", "");
            File outputDirectory = new File(project.getBuild().getOutputDirectory());
            boolean projectCompiledDuringThisSession = project.hasLifecyclePhase("compile") && COMPILE_PHASE_TYPES.contains(type);
            boolean bl = projectHasOutputFromPreviousSession = !this.session.getProjects().contains(project) && outputDirectory.exists();
            if (projectHasOutputFromPreviousSession || projectCompiledDuringThisSession) {
                return outputDirectory;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPackagedArtifactUpToDate(MavenProject project, File packagedArtifactFile) {
        Path outputDirectory = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        if (!outputDirectory.toFile().exists()) {
            return true;
        }
        try (Stream<Path> outputFiles = Files.walk(outputDirectory, new FileVisitOption[0]);){
            long buildStartTime;
            long artifactLastModified = Files.getLastModifiedTime(packagedArtifactFile.toPath(), new LinkOption[0]).toMillis();
            if (this.session.getProjectBuildingRequest().getBuildStartTime() != null && artifactLastModified > (buildStartTime = this.session.getProjectBuildingRequest().getBuildStartTime().getTime())) {
                boolean bl = true;
                return bl;
            }
            for (Path outputFile : outputFiles::iterator) {
                if (Files.isDirectory(outputFile, new LinkOption[0])) continue;
                long outputFileLastModified = Files.getLastModifiedTime(outputFile, new LinkOption[0]).toMillis();
                if (outputFileLastModified > artifactLastModified) {
                    LOGGER.warn("File '{}' is more recent than the packaged artifact for '{}', please run a full `mvn package` build", (Object)this.relativizeOutputFile(outputFile), (Object)project.getArtifactId());
                    boolean bl = false;
                    return bl;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("File '{}' timestamp {} vs artifact timestamp {} for '{}'", new Object[]{this.relativizeOutputFile(outputFile), outputFileLastModified, artifactLastModified, project.getArtifactId()});
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.warn("An I/O error occurred while checking if the packaged artifact is up-to-date against the build output directory. Continuing with the assumption that it is up-to-date.", (Throwable)e);
            return true;
        }
    }

    private boolean hasBeenPackagedDuringThisSession(MavenProject project) {
        boolean packaged = false;
        Iterator<String> iterator = this.getLifecycles(project).iterator();
        while (iterator.hasNext()) {
            String phase;
            switch (phase = iterator.next()) {
                case "clean": {
                    packaged = false;
                    break;
                }
                case "package": 
                case "install": 
                case "deploy": {
                    packaged = true;
                    break;
                }
            }
        }
        return packaged;
    }

    private Path relativizeOutputFile(Path outputFile) {
        Path rootDirectory = this.session.getRequest().getRootDirectory();
        return rootDirectory.relativize(outputFile);
    }

    private Artifact findMatchingArtifact(MavenProject project, Artifact requestedArtifact) {
        String requestedRepositoryConflictId = ArtifactIdUtils.toVersionlessId((Artifact)requestedArtifact);
        return this.getProjectArtifacts(project).filter(artifact -> Objects.equals(requestedRepositoryConflictId, ArtifactIdUtils.toVersionlessId((Artifact)artifact))).findFirst().orElse(null);
    }

    private static boolean isTestArtifact(Artifact artifact) {
        return "test-jar".equals(artifact.getProperty("type", "")) || "jar".equals(artifact.getExtension()) && "tests".equals(artifact.getClassifier());
    }

    private File findInProjectLocalRepository(Artifact artifact) {
        Path consumer;
        String classifier;
        if ("pom".equals(artifact.getExtension()) && ((classifier = artifact.getClassifier()) == null || classifier.isEmpty()) && Files.isRegularFile(consumer = this.getArtifactPath(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), "consumer", "pom"), new LinkOption[0])) {
            return consumer.toFile();
        }
        Path target = this.getArtifactPath(artifact);
        return Files.isRegularFile(target, new LinkOption[0]) ? target.toFile() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(ExecutionEvent event) {
        MavenProject project = event.getProject();
        switch (event.getType()) {
            case MojoStarted: {
                Deque<String> phases;
                String phase = event.getMojoExecution().getLifecyclePhase();
                if (phase == null || Objects.equals(phase, (phases = this.getLifecycles(project)).peekLast())) break;
                phases.addLast(phase);
                if (!"clean".equals(phase)) break;
                MavenProject mavenProject = project;
                synchronized (mavenProject) {
                    this.cleanProjectLocalRepository(project);
                    break;
                }
            }
            case ProjectSucceeded: 
            case ForkedProjectSucceeded: {
                MavenProject mavenProject = project;
                synchronized (mavenProject) {
                    this.installIntoProjectLocalRepository(project);
                    break;
                }
            }
        }
    }

    private Deque<String> getLifecycles(MavenProject project) {
        return this.lifecycles.computeIfAbsent(project.getId(), k -> new ArrayDeque());
    }

    private void installIntoProjectLocalRepository(MavenProject project) {
        if ("pom".equals(project.getPackaging()) && !"clean".equals(this.getLifecycles(project).peekLast()) || this.hasBeenPackagedDuringThisSession(project)) {
            this.getProjectArtifacts(project).filter(this::isRegularFile).forEach(this::installIntoProjectLocalRepository);
        }
    }

    private void cleanProjectLocalRepository(MavenProject project) {
        block11: {
            try {
                Path artifactPath = this.getProjectLocalRepo().resolve(project.getGroupId()).resolve(project.getArtifactId()).resolve(project.getVersion());
                if (!Files.isDirectory(artifactPath, new LinkOption[0])) break block11;
                try (Stream<Path> paths = Files.list(artifactPath);){
                    for (Path path : paths::iterator) {
                        Files.delete(path);
                    }
                }
                try {
                    Files.delete(artifactPath);
                    Files.delete(artifactPath.getParent());
                    Files.delete(artifactPath.getParent().getParent());
                }
                catch (DirectoryNotEmptyException directoryNotEmptyException) {}
            }
            catch (IOException e) {
                LOGGER.error("Error while cleaning project local repository", (Throwable)e);
            }
        }
    }

    private Stream<Artifact> getProjectArtifacts(MavenProject project) {
        Stream<ProjectArtifact> artifacts = Stream.concat(Stream.concat(Stream.of(new ProjectArtifact(project)), "pom".equals(project.getPackaging()) ? Stream.empty() : Stream.of(project.getArtifact())), project.getAttachedArtifacts().stream());
        return artifacts.map(RepositoryUtils::toArtifact);
    }

    private boolean isRegularFile(Artifact artifact) {
        return artifact.getFile() != null && artifact.getFile().isFile();
    }

    private void installIntoProjectLocalRepository(Artifact artifact) {
        String extension = artifact.getExtension();
        String classifier = artifact.getClassifier();
        Path target = this.getArtifactPath(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), classifier, extension);
        try {
            LOGGER.info("Copying {} to project local repository", (Object)artifact);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(artifact.getPath(), target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            LOGGER.error("Error while copying artifact to project local repository", (Throwable)e);
        }
    }

    private Path getArtifactPath(Artifact artifact) {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getBaseVersion();
        String classifier = artifact.getClassifier();
        String extension = artifact.getExtension();
        return this.getArtifactPath(groupId, artifactId, version, classifier, extension);
    }

    private Path getArtifactPath(String groupId, String artifactId, String version, String classifier, String extension) {
        Path repo = this.getProjectLocalRepo();
        return repo.resolve(groupId).resolve(artifactId).resolve(version).resolve(artifactId + "-" + version + (String)(classifier != null && !classifier.isEmpty() ? "-" + classifier : "") + "." + extension);
    }

    private Path getProjectLocalRepo() {
        if (this.projectLocalRepository == null) {
            Path root = this.session.getRequest().getRootDirectory();
            List<MavenProject> projects = this.session.getProjects();
            if (projects != null) {
                this.projectLocalRepository = projects.stream().filter(project -> Objects.equals(root.toFile(), project.getBasedir())).findFirst().map(project -> project.getBuild().getDirectory()).map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(() -> root.resolve("target")).resolve(PROJECT_LOCAL_REPO);
            } else {
                return root.resolve("target").resolve(PROJECT_LOCAL_REPO);
            }
        }
        return this.projectLocalRepository;
    }

    private MavenProject getProject(Artifact artifact) {
        return this.getProject(artifact, this.getProjects());
    }

    private MavenProject getProject(Artifact artifact, Map<String, Map<String, Map<String, MavenProject>>> projects) {
        return projects.getOrDefault(artifact.getGroupId(), Collections.emptyMap()).getOrDefault(artifact.getArtifactId(), Collections.emptyMap()).getOrDefault(artifact.getBaseVersion(), null);
    }

    private Map<String, Map<String, Map<String, MavenProject>>> getAllProjects() {
        if (this.allProjects == null) {
            List<MavenProject> allProjects = this.session.getAllProjects();
            if (allProjects != null) {
                HashMap<String, Map<String, Map<String, MavenProject>>> map = new HashMap<String, Map<String, Map<String, MavenProject>>>();
                allProjects.forEach(project -> map.computeIfAbsent(project.getGroupId(), k -> new HashMap()).computeIfAbsent(project.getArtifactId(), k -> new HashMap()).put(project.getVersion(), project));
                this.allProjects = map;
            } else {
                return Collections.emptyMap();
            }
        }
        return this.allProjects;
    }

    private Map<String, Map<String, Map<String, MavenProject>>> getProjects() {
        if (this.projects == null) {
            List<MavenProject> projects = this.session.getProjects();
            if (projects != null) {
                HashMap<String, Map<String, Map<String, MavenProject>>> map = new HashMap<String, Map<String, Map<String, MavenProject>>>();
                projects.forEach(project -> map.computeIfAbsent(project.getGroupId(), k -> new HashMap()).computeIfAbsent(project.getArtifactId(), k -> new HashMap()).put(project.getVersion(), project));
                this.projects = map;
            } else {
                return Collections.emptyMap();
            }
        }
        return this.projects;
    }

    @Named
    @Singleton
    static class ReactorReaderSpy
    implements EventSpy {
        private final Lookup lookup;

        @Inject
        ReactorReaderSpy(Lookup lookup) {
            this.lookup = lookup;
        }

        @Override
        public void init(EventSpy.Context context) throws Exception {
        }

        @Override
        public void onEvent(Object event) throws Exception {
            if (event instanceof ExecutionEvent) {
                ExecutionEvent executionEvent = (ExecutionEvent)event;
                ReactorReader reactorReader = (ReactorReader)this.lookup.lookup(ReactorReader.class);
                reactorReader.processEvent(executionEvent);
            }
        }

        @Override
        public void close() throws Exception {
        }
    }
}

