/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.cli.ParserRequest;
import org.apache.maven.api.cli.mvnup.UpgradeOptions;
import org.apache.maven.cling.invoker.CommonsCliOptions;

public class CommonsCliUpgradeOptions
extends CommonsCliOptions
implements UpgradeOptions {
    public static CommonsCliUpgradeOptions parse(String[] args) throws ParseException {
        CLIManager cliManager = new CLIManager();
        return new CommonsCliUpgradeOptions("CLI", cliManager, cliManager.parse(args));
    }

    protected CommonsCliUpgradeOptions(String source, CLIManager cliManager, CommandLine commandLine) {
        super(source, cliManager, commandLine);
    }

    @Nonnull
    public Optional<List<String>> goals() {
        if (!this.commandLine.getArgList().isEmpty()) {
            return Optional.of(this.commandLine.getArgList());
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<String> modelVersion() {
        if (this.commandLine.hasOption("m")) {
            return Optional.of(this.commandLine.getOptionValue("m"));
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<String> directory() {
        if (this.commandLine.hasOption("d")) {
            return Optional.of(this.commandLine.getOptionValue("d"));
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<Boolean> infer() {
        if (this.commandLine.hasOption("i")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<Boolean> model() {
        if (this.commandLine.hasOption("model")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<Boolean> plugins() {
        if (this.commandLine.hasOption("plugins")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<Boolean> all() {
        if (this.commandLine.hasOption("a")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    @Override
    public void displayHelp(ParserRequest request, Consumer<String> printStream) {
        super.displayHelp(request, printStream);
        printStream.accept("");
        printStream.accept("Goals:");
        printStream.accept("  help  - display this help message");
        printStream.accept("  check - check for available upgrades");
        printStream.accept("  apply - apply available upgrades");
        printStream.accept("");
        printStream.accept("Options:");
        printStream.accept("  -m, --model-version <version> Target POM model version (4.0.0 or 4.1.0)");
        printStream.accept("  -d, --directory <path> Directory to use as starting point for POM discovery");
        printStream.accept("  -i, --infer           Remove redundant information that can be inferred by Maven");
        printStream.accept("      --model           Fix Maven 4 compatibility issues in POM files");
        printStream.accept("      --plugins         Upgrade plugins known to fail with Maven 4");
        printStream.accept("  -a, --all             Apply all upgrades (equivalent to --model-version 4.1.0 --infer --model --plugins)");
        printStream.accept("");
        printStream.accept("Default behavior: --model --plugins --infer are applied if no other options are specified");
        printStream.accept("");
    }

    @Override
    protected CommonsCliUpgradeOptions copy(String source, CommonsCliOptions.CLIManager cliManager, CommandLine commandLine) {
        return new CommonsCliUpgradeOptions(source, (CLIManager)cliManager, commandLine);
    }

    protected static class CLIManager
    extends CommonsCliOptions.CLIManager {
        public static final String MODEL_VERSION = "m";
        public static final String DIRECTORY = "d";
        public static final String INFER = "i";
        public static final String MODEL = "model";
        public static final String PLUGINS = "plugins";
        public static final String ALL = "a";

        protected CLIManager() {
        }

        @Override
        protected void prepareOptions(Options options) {
            super.prepareOptions(options);
            options.addOption(Option.builder((String)MODEL_VERSION).longOpt("model-version").hasArg().argName("version").desc("Target POM model version (4.0.0 or 4.1.0)").get());
            options.addOption(Option.builder((String)DIRECTORY).longOpt("directory").hasArg().argName("path").desc("Directory to use as starting point for POM discovery").get());
            options.addOption(Option.builder((String)INFER).longOpt("infer").desc("Use inference when upgrading (remove redundant information)").get());
            options.addOption(Option.builder((String)MODEL).longOpt(MODEL).desc("Fix Maven 4 compatibility issues in POM files").get());
            options.addOption(Option.builder((String)PLUGINS).longOpt(PLUGINS).desc("Upgrade plugins known to fail with Maven 4 to their minimum compatible versions").get());
            options.addOption(Option.builder((String)ALL).longOpt("all").desc("Apply all upgrades (equivalent to --model-version 4.1.0 --infer --model --plugins)").get());
        }
    }
}

