/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.common.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public abstract class AbstractIdentityAsserterDeploymentContributor
extends ProviderDeploymentContributorBase {
    public static final String IMPERSONATION_PARAMS = "impersonation.params";
    static final String ROLE = "identity-assertion";

    public String getRole() {
        return ROLE;
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        params = this.buildFilterInitParms(provider, resource, params);
        params = this.buildServiceParams(service, resource, params);
        resource.addFilter().name(this.getName()).role(this.getRole()).impl(this.getFilterClassname()).params(params);
    }

    protected List<FilterParamDescriptor> buildServiceParams(Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        if (params == null) {
            params = new ArrayList<FilterParamDescriptor>();
        }
        Map serviceParams = service.getParams();
        for (Map.Entry entry : serviceParams.entrySet()) {
            FilterParamDescriptor f = resource.createFilterParam().name(((String)entry.getKey()).toLowerCase(Locale.ROOT)).value((String)entry.getValue());
            if (params.contains(f)) continue;
            params.add(f);
        }
        return params;
    }

    public List<FilterParamDescriptor> buildFilterInitParms(Provider provider, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        if (params == null) {
            params = new ArrayList<FilterParamDescriptor>();
        }
        Map providerParams = provider.getParams();
        for (Map.Entry entry : providerParams.entrySet()) {
            params.add(resource.createFilterParam().name(((String)entry.getKey()).toLowerCase(Locale.ROOT)).value((String)entry.getValue()));
        }
        return params;
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
        super.contributeProvider(context, provider);
        String impersonationParams = (String)provider.getParams().get(IMPERSONATION_PARAMS);
        context.getWebAppDescriptor().createContextParam().paramName(IMPERSONATION_PARAMS).paramValue(impersonationParams);
    }

    protected abstract String getFilterClassname();
}

