/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiLicenseFeature;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Information about the Cloudera Manager license.")
public class ApiLicense {
    @SerializedName(value="owner")
    private String owner = null;
    @SerializedName(value="uuid")
    private String uuid = null;
    @SerializedName(value="expiration")
    private String expiration = null;
    @SerializedName(value="features")
    private List<ApiLicenseFeature> features = null;
    @SerializedName(value="deactivationDate")
    private String deactivationDate = null;
    @SerializedName(value="startDate")
    private String startDate = null;

    public ApiLicense owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Schema(description="The owner (organization name) of the license.")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ApiLicense uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(description="A UUID of this license.")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ApiLicense expiration(String expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="The expiration date.")
    public String getExpiration() {
        return this.expiration;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public ApiLicense features(List<ApiLicenseFeature> features) {
        this.features = features;
        return this;
    }

    public ApiLicense addFeaturesItem(ApiLicenseFeature featuresItem) {
        if (this.features == null) {
            this.features = new ArrayList<ApiLicenseFeature>();
        }
        this.features.add(featuresItem);
        return this;
    }

    @Schema(description="Returns the list of available features as per the license")
    public List<ApiLicenseFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<ApiLicenseFeature> features) {
        this.features = features;
    }

    public ApiLicense deactivationDate(String deactivationDate) {
        this.deactivationDate = deactivationDate;
        return this;
    }

    @Schema(description="The deactivation date.")
    public String getDeactivationDate() {
        return this.deactivationDate;
    }

    public void setDeactivationDate(String deactivationDate) {
        this.deactivationDate = deactivationDate;
    }

    public ApiLicense startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(description="The start date.")
    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiLicense apiLicense = (ApiLicense)o;
        return Objects.equals(this.owner, apiLicense.owner) && Objects.equals(this.uuid, apiLicense.uuid) && Objects.equals(this.expiration, apiLicense.expiration) && Objects.equals(this.features, apiLicense.features) && Objects.equals(this.deactivationDate, apiLicense.deactivationDate) && Objects.equals(this.startDate, apiLicense.startDate);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.uuid, this.expiration, this.features, this.deactivationDate, this.startDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiLicense {\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    deactivationDate: ").append(this.toIndentedString(this.deactivationDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

