/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.util.MachineList;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class KnoxImpersonationProvider
extends DefaultImpersonationProvider {
    private static final GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private static final String CONF_HOSTS = ".hosts";
    private static final String CONF_USERS = ".users";
    private static final String CONF_GROUPS = ".groups";
    private static final String PREFIX_REGEX_EXP = "\\.";
    private static final String USERS_GROUPS_REGEX_EXP = "[\\S]*(" + Pattern.quote(".users") + "|" + Pattern.quote(".groups") + ")";
    private static final String HOSTS_REGEX_EXP = "[\\S]*" + Pattern.quote(".hosts");
    private final Map<String, AccessControlList> proxyGroupsAcls = new HashMap<String, AccessControlList>();
    private Map<String, MachineList> groupProxyHosts = new HashMap<String, MachineList>();
    private String groupConfigPrefix;
    private boolean doesProxyUserConfigExist = true;
    private boolean doesProxyGroupConfigExist;
    static final String IMPERSONATION_ENABLED_PARAM = ".impersonation.enabled";

    public Configuration getConf() {
        return super.getConf();
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
    }

    public void init(String configurationPrefix) {
        super.init(configurationPrefix);
        this.doesProxyUserConfigExist = !this.getFilteredProps("hadoop.proxyuser").isEmpty();
        this.doesProxyGroupConfigExist = !this.getFilteredProps("hadoop.proxygroup").isEmpty();
        this.initGroupBasedProvider("hadoop.proxygroup");
    }

    private Map<String, String> getFilteredProps(String prefix) {
        return Optional.ofNullable(this.getConf().getPropsWithPrefix(prefix)).orElse(Collections.emptyMap()).entrySet().stream().filter(entry -> !IMPERSONATION_ENABLED_PARAM.equals(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void initGroupBasedProvider(String proxyGroupPrefix) {
        this.groupConfigPrefix = proxyGroupPrefix + (proxyGroupPrefix.endsWith(".") ? "" : ".");
        String prefixRegEx = this.groupConfigPrefix.replace(".", PREFIX_REGEX_EXP);
        String usersGroupsRegEx = prefixRegEx + USERS_GROUPS_REGEX_EXP;
        String hostsRegEx = prefixRegEx + HOSTS_REGEX_EXP;
        Map allMatchKeys = this.getConf().getValByRegex(usersGroupsRegEx);
        for (Map.Entry entry : allMatchKeys.entrySet()) {
            String aclKey = this.getAclKey((String)entry.getKey());
            if (this.proxyGroupsAcls.containsKey(aclKey)) continue;
            this.proxyGroupsAcls.put(aclKey, new AccessControlList((String)allMatchKeys.get(aclKey + CONF_USERS), (String)allMatchKeys.get(aclKey + CONF_GROUPS)));
        }
        allMatchKeys = this.getConf().getValByRegex(hostsRegEx);
        for (Map.Entry entry : allMatchKeys.entrySet()) {
            this.groupProxyHosts.put((String)entry.getKey(), new MachineList((String)entry.getValue()));
        }
    }

    private String getAclKey(String key) {
        int endIndex = key.lastIndexOf(46);
        if (endIndex != -1) {
            return key.substring(0, endIndex);
        }
        return key;
    }

    public void authorize(UserGroupInformation user, InetAddress remoteAddress) throws AuthorizationException {
        this.authorize(user, remoteAddress, Collections.emptyList());
    }

    public void authorize(UserGroupInformation user, InetAddress remoteAddress, List<String> groups) throws AuthorizationException {
        if (this.doesProxyUserConfigExist) {
            try {
                super.authorize(user, remoteAddress);
            }
            catch (AuthorizationException e) {
                LOG.failedToImpersonateUserTryingGroups(user.getUserName(), e.toString());
                if (this.doesProxyGroupConfigExist) {
                    this.checkProxyGroupAuthorization(user, remoteAddress, groups);
                }
                throw e;
            }
        } else if (this.doesProxyGroupConfigExist) {
            this.checkProxyGroupAuthorization(user, remoteAddress, groups);
        } else {
            LOG.noProxyUserOrGroupConfigExists();
            throw new AuthorizationException("User: " + user.getRealUser() + " is not allowed to impersonate " + user.getUserName());
        }
    }

    private void checkProxyGroupAuthorization(UserGroupInformation user, InetAddress remoteAddress, List<String> groups) throws AuthorizationException {
        if (user == null) {
            throw new IllegalArgumentException("user is null.");
        }
        UserGroupInformation realUser = user.getRealUser();
        if (realUser == null) {
            return;
        }
        HashSet<String> realUserGroups = new HashSet<String>();
        if (groups != null && !groups.isEmpty()) {
            realUserGroups.addAll(groups);
        }
        if (user.getRealUser().getGroupNames() != null) {
            Collections.addAll(realUserGroups, user.getRealUser().getGroupNames());
        }
        boolean proxyGroupFound = false;
        if (!(proxyGroupFound = this.isProxyGroupFound(user, realUserGroups, proxyGroupFound))) {
            LOG.failedToImpersonateGroups(realUser.getUserName(), ((Object)realUserGroups).toString(), user.getUserName());
            throw new AuthorizationException("User: " + realUser.getUserName() + " with groups " + ((Object)realUserGroups).toString() + " is not allowed to impersonate " + user.getUserName());
        }
        boolean proxyGroupHostFound = false;
        if (!(proxyGroupHostFound = this.isProxyGroupHostFound(remoteAddress, realUserGroups, proxyGroupHostFound))) {
            LOG.failedToImpersonateGroupsFromAddress(realUser.getUserName(), ((Object)realUserGroups).toString(), user.getUserName(), remoteAddress.toString());
            throw new AuthorizationException("User: " + realUser.getUserName() + " with groups " + ((Object)realUserGroups).toString() + " from address " + remoteAddress.toString() + " is not allowed to impersonate " + user.getUserName());
        }
    }

    private boolean isProxyGroupHostFound(InetAddress remoteAddress, Set<String> realUserGroups, boolean proxyGroupHostFound) {
        for (String group : realUserGroups) {
            MachineList machineList = this.groupProxyHosts.get(this.groupConfigPrefix + group + CONF_HOSTS);
            if (machineList == null || !machineList.includes(remoteAddress)) continue;
            proxyGroupHostFound = true;
            break;
        }
        return proxyGroupHostFound;
    }

    private boolean isProxyGroupFound(UserGroupInformation user, Set<String> realUserGroups, boolean proxyGroupFound) {
        for (String group : realUserGroups) {
            AccessControlList acl = this.proxyGroupsAcls.get(this.groupConfigPrefix + group);
            if (acl == null || !acl.isUserAllowed(user)) continue;
            proxyGroupFound = true;
            break;
        }
        return proxyGroupFound;
    }
}

