/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.livy;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.dispatch.ConfigurableDispatch;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteRequestStream;
import org.apache.knox.gateway.security.SubjectUtils;

public class LivyDispatch
extends ConfigurableDispatch {
    public void doPost(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        super.doPost(url, (HttpServletRequest)new LivyHttpServletRequest(request), response);
    }

    private class LivyHttpServletRequest
    extends HttpServletRequestWrapper {
        private final List<String> proxyUserEndpoints;

        LivyHttpServletRequest(HttpServletRequest request) {
            super(request);
            this.proxyUserEndpoints = Arrays.asList("/batches", "/sessions");
        }

        public ServletInputStream getInputStream() throws IOException {
            ServletInputStream inputStream = super.getInputStream();
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            String requestURI = request.getRequestURI();
            if (this.matchProxyUserEndpoints(requestURI)) {
                ObjectMapper objectMapper = new ObjectMapper();
                Map jsonMap = (Map)objectMapper.readValue((InputStream)inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
                jsonMap.put("proxyUser", SubjectUtils.getCurrentEffectivePrincipalName());
                String s = objectMapper.writeValueAsString((Object)jsonMap);
                return new UrlRewriteRequestStream((InputStream)new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)));
            }
            return inputStream;
        }

        private boolean matchProxyUserEndpoints(String requestURI) {
            for (String endpoint : this.proxyUserEndpoints) {
                if (!requestURI.endsWith(endpoint) && !requestURI.endsWith(endpoint + '/')) continue;
                return true;
            }
            return false;
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), StandardCharsets.UTF_8));
        }
    }
}

