/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.apache.knox.gateway.shell.table.KnoxShellTableCall;
import org.apache.knox.gateway.shell.table.KnoxShellTableCallHistory;
import org.apache.knox.gateway.shell.table.KnoxShellTableFilterException;

public class KnoxShellTableFilter {
    final KnoxShellTable filteredTable = new KnoxShellTable();
    final KnoxShellTable tableToFilter;
    private int index;

    KnoxShellTableFilter(KnoxShellTable table) {
        this.tableToFilter = table;
        List<KnoxShellTableCall> callHistory = KnoxShellTableCallHistory.getInstance().getCallHistory(this.tableToFilter.id);
        KnoxShellTableCallHistory.getInstance().saveCalls(this.filteredTable.id, callHistory);
    }

    public KnoxShellTableFilter name(String name) throws KnoxShellTableFilterException {
        for (int i = 0; i < this.tableToFilter.headers.size(); ++i) {
            if (!this.tableToFilter.headers.get(i).equalsIgnoreCase(name)) continue;
            this.index = i;
            break;
        }
        if (this.index == -1) {
            throw new KnoxShellTableFilterException("Column name not found");
        }
        return this;
    }

    public KnoxShellTableFilter index(int index) {
        this.index = index;
        return this;
    }

    public KnoxShellTable regex(Comparable<String> regex) {
        Pattern pattern = Pattern.compile((String)((Object)regex));
        this.prepareFilteredTable();
        for (List<Comparable<? extends Object>> row : this.tableToFilter.rows) {
            if (!pattern.matcher(row.get(this.index).toString()).matches()) continue;
            this.filteredTable.row();
            row.forEach(value -> this.filteredTable.value((Comparable<? extends Object>)value));
        }
        return this.filteredTable;
    }

    private void prepareFilteredTable() {
        this.filteredTable.headers.addAll(this.tableToFilter.headers);
        this.filteredTable.title(this.tableToFilter.title);
    }

    private KnoxShellTable filter(Predicate<Comparable> p) throws KnoxShellTableFilterException {
        try {
            this.prepareFilteredTable();
            for (List<Comparable<? extends Object>> row : this.tableToFilter.rows) {
                if (!p.test(row.get(this.index))) continue;
                this.filteredTable.row();
                row.forEach(value -> this.filteredTable.value((Comparable<? extends Object>)value));
            }
            return this.filteredTable;
        }
        catch (Exception e) {
            throw new KnoxShellTableFilterException(e);
        }
    }

    public KnoxShellTable greaterThan(Comparable<? extends Object> comparable) throws KnoxShellTableFilterException {
        return this.filter(s -> s.compareTo(comparable) > 0);
    }

    public KnoxShellTable lessThan(Comparable<? extends Object> comparable) throws KnoxShellTableFilterException {
        return this.filter(s -> s.compareTo(comparable) < 0);
    }

    public KnoxShellTable greaterThanOrEqualTo(Comparable<? extends Object> comparable) throws KnoxShellTableFilterException {
        return this.filter(s -> s.compareTo(comparable) > 0 || s.equals(comparable));
    }

    public KnoxShellTable lessThanOrEqualTo(Comparable<? extends Object> comparable) throws KnoxShellTableFilterException {
        return this.filter(s -> s.compareTo(comparable) < 0 || s.equals(comparable));
    }

    public KnoxShellTable equalTo(Comparable<? extends Object> comparable) throws KnoxShellTableFilterException {
        return this.filter(s -> s.equals(comparable));
    }
}

