/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;

public class BaseLevelScopeEvaluator<E>
implements Evaluator<ScopeNode> {
    private final ScopeNode node;
    private final String baseId;
    private final boolean dereferencing;
    private final Store db;

    public BaseLevelScopeEvaluator(Store db, ScopeNode node) {
        this.node = node;
        this.db = db;
        this.baseId = node.getBaseId();
        this.dereferencing = node.getDerefAliases().isDerefInSearching() || node.getDerefAliases().isDerefAlways();
    }

    @Override
    public boolean evaluate(Entry candidate) throws LdapException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_721, (Object[])new Object[0]));
    }

    @Override
    public boolean evaluate(PartitionTxn partitionTxn, IndexEntry<?, String> indexEntry) throws LdapException {
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.fetch(partitionTxn, indexEntry.getId());
            if (null == entry) {
                return false;
            }
            indexEntry.setEntry(entry);
        }
        return true;
    }

    @Override
    public ScopeNode getExpression() {
        return this.node;
    }

    public String getBaseId() {
        return this.baseId;
    }

    public boolean isDereferencing() {
        return this.dereferencing;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("BaseLevelScopEvaluator : ").append(this.node).append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

