/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.event.service;

import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventCollector
implements EventHandler {
    private Deque<Event> events = new ConcurrentLinkedDeque<Event>();
    private int maxSize = 100;
    private Set<Consumer<Event>> consumers = new HashSet<Consumer<Event>>();

    public synchronized void handleEvent(Event event) {
        this.events.addLast(event);
        if (this.events.size() > this.maxSize) {
            this.events.removeFirst();
        }
        this.consumers.forEach(c -> c.accept(event));
    }

    public Stream<Event> getEvents() {
        return this.events.stream();
    }

    public synchronized void addConsumer(Consumer<Event> eventConsumer) {
        this.events.forEach(eventConsumer);
        this.consumers.add(eventConsumer);
    }

    public synchronized void removeConsumer(Consumer<Event> eventConsumer) {
        this.consumers.remove(eventConsumer);
    }
}

