/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ClassUtils;

public enum Visibility {
    NONE,
    PUBLIC,
    PROTECTED,
    DEFAULT,
    PRIVATE;


    public boolean isVisible(Class<?> x) {
        return this.isVisible(x.getModifiers());
    }

    public boolean isVisible(Executable x) {
        return this.isVisible(x.getModifiers());
    }

    public boolean isVisible(Field x) {
        return this.isVisible(x.getModifiers());
    }

    public boolean isVisible(int mod) {
        return switch (this) {
            case NONE -> false;
            case PRIVATE -> true;
            case DEFAULT -> {
                if (!Modifier.isPrivate(mod)) {
                    yield true;
                }
                yield false;
            }
            case PROTECTED -> {
                if (Modifier.isProtected(mod) || Modifier.isPublic(mod)) {
                    yield true;
                }
                yield false;
            }
            default -> Modifier.isPublic(mod);
        };
    }

    public <T> Constructor<T> transform(Constructor<T> x) {
        AssertionUtils.assertArgNotNull("x", x);
        if (this.isVisible(x) && !ClassUtils.setAccessible(x)) {
            return null;
        }
        return x;
    }

    public Field transform(Field x) {
        AssertionUtils.assertArgNotNull("x", x);
        if (this.isVisible(x) && !ClassUtils.setAccessible(x)) {
            return null;
        }
        return x;
    }

    public Method transform(Method x) {
        AssertionUtils.assertArgNotNull("x", x);
        if (this.isVisible(x) && !ClassUtils.setAccessible(x)) {
            return null;
        }
        return x;
    }
}

