/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.sparql.vocabulary ;

/* CVS $Id: $ */

import org.apache.jena.rdf.model.Model ;
import org.apache.jena.rdf.model.ModelFactory ;
import org.apache.jena.rdf.model.Property ;
import org.apache.jena.rdf.model.Resource ;

/**
 * Vocabulary definitions from FOAF.rdf
 * @author Auto-generated by schemagen on 11 Oct 2017 20:53
 */
public class FOAF {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static final Model M_MODEL = ModelFactory.createDefaultModel();

    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://xmlns.com/foaf/0.1/";

    /** <p>The namespace of the vocabulary as a string</p>
     * @return namespace as String
     * @see #NS */
    public static String getURI() {return NS;}

    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = M_MODEL.createResource( NS );

    /** <p>Indicates an account held by this agent.</p> */
    public static final Property account = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/account" );

    /** <p>Indicates the name (identifier) associated with this online account.</p> */
    public static final Property accountName = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/accountName" );

    /** <p>Indicates a homepage of the service provide for this online account.</p> */
    public static final Property accountServiceHomepage = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/accountServiceHomepage" );

    /** <p>The age in years of some agent.</p> */
    public static final Property age = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/age" );

    /** <p>An AIM chat ID</p> */
    public static final Property aimChatID = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/aimChatID" );

    /** <p>A location that something is based near, for some broadly human notion of
     *  near.</p>
     */
    public static final Property based_near = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/based_near" );

    /** <p>The birthday of this Agent, represented in mm-dd string form, eg. '12-31'.</p> */
    public static final Property birthday = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/birthday" );

    /** <p>A current project this person works on.</p> */
    public static final Property currentProject = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/currentProject" );

    /** <p>A depiction of some thing.</p> */
    public static final Property depiction = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/depiction" );

    /** <p>A thing depicted in this representation.</p> */
    public static final Property depicts = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/depicts" );

    /**
     * <p>A checksum for the DNA of some thing. Joke.</p>
     *
     * @deprecated  Archaic term. No replacement.
     */
    @Deprecated
    public static final Property dnaChecksum = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/dnaChecksum" );

    /** <p>The family name of some person.</p> */
    public static final Property familyName = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/familyName" );

    /**
     * <p>The family name of some person.</p>
     *
     * @deprecated  Archaic term. Replaced by {@link #familyName}.
     */
    @Deprecated
    public static final Property family_name = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/family_name" );

    /** <p>The first name of a person.</p> */
    public static final Property firstName = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/firstName" );

    /** <p>The underlying or 'focal' entity associated with some SKOS-described concept.</p> */
    public static final Property focus = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/focus" );

    /**
     * <p>An organization funding a project or person.</p>
     *
     * @deprecated  Archaic term. No replacement.
     */
    @Deprecated
    public static final Property fundedBy = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/fundedBy" );

    /**
     * <p>A textual geekcode for this person, see http://www.geekcode.com/geek.html</p>
     *
     * @deprecated  Archaic term. No replacement.
     */
    @Deprecated
    public static final Property geekcode = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/geekcode" );

    /** <p>The gender of this Agent (typically but not necessarily 'male' or 'female').</p> */
    public static final Property gender = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/gender" );

    /** <p>The given name of some person.</p> */
    public static final Property givenName = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/givenName" );

    /**
     * <p>The given name of some person.</p>
     *
     * @deprecated  Archaic term. Replaced by {@link #givenName}.
     */
    @Deprecated
    public static final Property givenname = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/givenname" );

    /**
     * <p>Indicates an account held by this agent.</p>
     *
     * @deprecated  Archaic term. Replaced by {@link #account}
     */
    @Deprecated
    public static final Property holdsAccount = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/holdsAccount" );

    /** <p>A homepage for some thing.</p> */
    public static final Property homepage = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/homepage" );

    /** <p>An ICQ chat ID</p> */
    public static final Property icqChatID = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/icqChatID" );

    /** <p>An image that can be used to represent some thing (ie. those depictions which
     *  are particularly representative of something, eg. one's photo on a homepage).</p>
     */
    public static final Property img = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/img" );

    /** <p>A page about a topic of interest to this person.</p> */
    public static final Property interest = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/interest" );

    /** <p>A document that this thing is the primary topic of.</p> */
    public static final Property isPrimaryTopicOf = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/isPrimaryTopicOf" );

    /** <p>A jabber ID for something.</p> */
    public static final Property jabberID = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/jabberID" );

    /** <p>A person known by this person (indicating some level of reciprocated interaction
     *  between the parties).</p>
     */
    public static final Property knows = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/knows" );

    /** <p>The last name of a person.</p> */
    public static final Property lastName = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/lastName" );

    /** <p>A logo representing some thing.</p> */
    public static final Property logo = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/logo" );

    /** <p>Something that was made by this agent.</p> */
    public static final Property made = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/made" );

    /** <p>An agent that made this thing.</p> */
    public static final Property maker = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/maker" );

    /** <p>A personal mailbox, ie. an Internet mailbox associated with exactly one owner,
     *  the first owner of this mailbox. This is a 'static inverse functional property',
     *  in that there is (across time and change) at most one individual that ever
     *  has any particular value for foaf:mbox.</p>
     */
    public static final Property mbox = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/mbox" );

    /** <p>The sha1sum of the URI of an Internet mailbox associated with exactly one
     *  owner, the first owner of the mailbox.</p>
     */
    public static final Property mbox_sha1sum = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/mbox_sha1sum" );

    /** <p>Indicates a member of a Group</p> */
    public static final Property member = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/member" );

    /** <p>Indicates the class of individuals that are a member of a Group</p> */
    public static final Property membershipClass = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/membershipClass" );

    /** <p>An MSN chat ID</p> */
    public static final Property msnChatID = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/msnChatID" );

    /** <p>A Myers Briggs (MBTI) personality classification.</p> */
    public static final Property myersBriggs = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/myersBriggs" );

    /** <p>A name for some thing.</p> */
    public static final Property name = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/name" );

    /** <p>A short informal nickname characterising an agent (includes login identifiers,
     *  IRC and other chat nicknames).</p>
     */
    public static final Property nick = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/nick" );

    /** <p>An OpenID for an Agent.</p> */
    public static final Property openid = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/openid" );

    /** <p>A page or document about this thing.</p> */
    public static final Property page = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/page" );

    /** <p>A project this person has previously worked on.</p> */
    public static final Property pastProject = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/pastProject" );

    /** <p>A phone, specified using fully qualified tel: URI scheme (refs: http://www.w3.org/Addressing/schemes.html#tel).</p> */
    public static final Property phone = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/phone" );

    /** <p>A .plan comment, in the tradition of finger and '.plan' files.</p> */
    public static final Property plan = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/plan" );

    /** <p>The primary topic of some page or document.</p> */
    public static final Property primaryTopic = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/primaryTopic" );

    /** <p>A link to the publications of this person.</p> */
    public static final Property publications = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/publications" );

    /** <p>A homepage of a school attended by the person.</p> */
    public static final Property schoolHomepage = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/schoolHomepage" );

    /** <p>A sha1sum hash, in hex.</p> */
    public static final Property sha1 = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/sha1" );

    /** <p>A Skype ID</p> */
    public static final Property skypeID = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/skypeID" );

    /** <p>A string expressing what the user is happy for the general public (normally)
     *  to know about their current activity.</p>
     */
    public static final Property status = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/status" );

    /**
     * <p>The surname of some person.</p>
     *
     * @deprecated  Archaic term. Replaced by {@link #familyName}.
     */
    @Deprecated
    public static final Property surname = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/surname" );

    /**
     * <p>A theme.</p>
     *
     * @deprecated  Archaic term. No replacement.
     */
    @Deprecated
    public static final Property theme = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/theme" );

    /** <p>A derived thumbnail image.</p> */
    public static final Property thumbnail = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/thumbnail" );

    /** <p>A tipjar document for this agent, describing means for payment and reward.</p> */
    public static final Property tipjar = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/tipjar" );

    /** <p>Title (Mr, Mrs, Ms, Dr. etc)</p> */
    public static final Property title = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/title" );

    /** <p>A topic of some page or document.</p> */
    public static final Property topic = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/topic" );

    /** <p>A thing of interest to this person.</p> */
    public static final Property topic_interest = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/topic_interest" );

    /** <p>A weblog of some thing (whether person, group, company etc.).</p> */
    public static final Property weblog = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/weblog" );

    /** <p>A work info homepage of some person; a page about their work for some organization.</p> */
    public static final Property workInfoHomepage = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/workInfoHomepage" );

    /** <p>A workplace homepage of some person; the homepage of an organization they
     *  work for.</p>
     */
    public static final Property workplaceHomepage = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/workplaceHomepage" );

    /** <p>A Yahoo chat ID</p> */
    public static final Property yahooChatID = M_MODEL.createProperty( "http://xmlns.com/foaf/0.1/yahooChatID" );

    /** <p>An agent (eg. person, group, software or physical artifact).</p> */
    public static final Resource Agent = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/Agent" );

    /** <p>A document.</p> */
    public static final Resource Document = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/Document" );

    /** <p>A class of Agents.</p> */
    public static final Resource Group = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/Group" );

    /** <p>An image.</p> */
    public static final Resource Image = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/Image" );

    /** <p>A foaf:LabelProperty is any RDF property with texual values that serve as
     *  labels.</p>
     */
    public static final Resource LabelProperty = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/LabelProperty" );

    /** <p>An online account.</p> */
    public static final Resource OnlineAccount = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/OnlineAccount" );

    /** <p>An online chat account.</p> */
    public static final Resource OnlineChatAccount = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/OnlineChatAccount" );

    /** <p>An online e-commerce account.</p> */
    public static final Resource OnlineEcommerceAccount = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/OnlineEcommerceAccount" );

    /** <p>An online gaming account.</p> */
    public static final Resource OnlineGamingAccount = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/OnlineGamingAccount" );

    /** <p>An organization.</p> */
    public static final Resource Organization = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/Organization" );

    /** <p>A person.</p> */
    public static final Resource Person = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/Person" );

    /** <p>A personal profile RDF document.</p> */
    public static final Resource PersonalProfileDocument = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/PersonalProfileDocument" );

    /** <p>A project (a collective endeavour of some kind).</p> */
    public static final Resource Project = M_MODEL.createResource( "http://xmlns.com/foaf/0.1/Project" );

}
