/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package arq;

import java.io.InputStream ;
import java.io.OutputStream ;

import org.apache.jena.sparql.engine.binding.BindingInputStream ;
import org.apache.jena.sparql.engine.binding.BindingOutputStream ;

/** Simple command for testing bindings */
public class bindings
{
    public static void main(String... args)
    {
        InputStream in = System.in ;
        OutputStream out = System.out ;
        
        BindingInputStream input = new BindingInputStream(in) ;
        BindingOutputStream output = new BindingOutputStream(out) ;
        
        for ( ; input.hasNext() ; )
            output.send(input.next()) ;
        output.flush() ;
    }
}
