/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.assembler.exceptions;

import org.apache.jena.rdf.model.Resource ;

/**
    Exception to throw when some (dynamically loaded) class isn't of the
    required type.
*/
public class NotExpectedTypeException extends AssemblerException
    {
    protected final Class<?> expectedType;
    protected final Class<?> actualType;
    
    public NotExpectedTypeException( Resource root, Class<?> expectedType, Class<?> actualType )
        {
        super( root, "expected class " + expectedType.getName() + ", but had class " + actualType.getName() );
        this.expectedType = expectedType;
        this.actualType = actualType;
        }

    public Class<?> getExpectedType()
        { return expectedType; }

    public Class<?> getActualType()
        { return actualType; }
    }
