/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.memvalue;

import java.util.Spliterator;
import org.apache.jena.graph.Triple;
import org.apache.jena.memvalue.ByValue;
import org.apache.jena.memvalue.HashCommon;
import org.apache.jena.memvalue.TripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;

class HashedTripleBunch
extends HashCommon<Triple>
implements TripleBunch {
    HashedTripleBunch(TripleBunch b) {
        super(HashedTripleBunch.nextSize((int)((double)b.size() / 0.5)));
        b.spliterator().forEachRemaining(this::add);
        this.changes = 0;
    }

    protected Triple[] newKeyArray(int size) {
        return new Triple[size];
    }

    @Override
    public boolean contains(Triple t) {
        return this.findSlot(t) < 0;
    }

    protected int findSlotBySameValueAs(Triple key) {
        int index = this.initialIndexFor(key);
        Triple current;
        while ((current = ((Triple[])this.keys)[index]) != null) {
            if (ByValue.sameByValue(key, current)) {
                return ~index;
            }
            if (--index >= 0) continue;
            index += this.capacity;
        }
        return index;
    }

    @Override
    public boolean containsBySameValueAs(Triple t) {
        return this.findSlotBySameValueAs(t) < 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    int currentCapacity() {
        return this.capacity;
    }

    @Override
    public void add(Triple t) {
        ((Triple[])this.keys)[this.findSlot(t)] = t;
        ++this.changes;
        if (++this.size > this.threshold) {
            this.grow();
        }
    }

    protected void grow() {
        Object[] oldContents = this.keys;
        int oldCapacity = this.capacity;
        this.growCapacityAndThreshold();
        this.keys = new Triple[this.capacity];
        Triple[] newKeys = this.keys;
        for (int i = 0; i < oldCapacity; ++i) {
            Triple t = (Triple)oldContents[i];
            if (t == null) continue;
            newKeys[this.findSlot(t)] = t;
        }
    }

    @Override
    public void remove(Triple t) {
        super.remove(t);
        ++this.changes;
    }

    @Override
    public ExtendedIterator<Triple> iterator() {
        return this.iterator(HashCommon.NotifyEmpty.ignore);
    }

    @Override
    public ExtendedIterator<Triple> iterator(HashCommon.NotifyEmpty container) {
        return this.keyIterator(container);
    }

    @Override
    public Spliterator<Triple> spliterator() {
        return super.keySpliterator();
    }
}

