/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.NodeVisitor;
import org.apache.jena.graph.Node_ANY;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sys.Serializer;

public abstract class Node
implements Serializable {
    public static final Node ANY = Node_ANY.nodeANY;
    public static final String noLangTag = "";
    public static final TextDirection noTextDirection = null;
    protected static final int hashURI = 30;
    protected static final int hashVariable = 29;
    protected static final int hashANY = 28;
    protected static final int hashNodeTriple = 27;
    protected static final int hashExt = 26;
    protected static final int hashBNode = 25;

    public abstract Object visitWith(NodeVisitor var1);

    public abstract boolean isConcrete();

    public boolean isLiteral() {
        return false;
    }

    public boolean isBlank() {
        return false;
    }

    public boolean isURI() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isTripleTerm() {
        return false;
    }

    public boolean isNodeGraph() {
        return false;
    }

    public boolean isExt() {
        return false;
    }

    public String getBlankNodeLabel() {
        throw new UnsupportedOperationException(String.valueOf(this) + " is not a blank node");
    }

    public LiteralLabel getLiteral() {
        throw new UnsupportedOperationException(String.valueOf(this) + " is not a literal node");
    }

    public Object getLiteralValue() {
        throw new NotLiteral(this);
    }

    public String getLiteralLexicalForm() {
        throw new NotLiteral(this);
    }

    public String getLiteralLanguage() {
        throw new NotLiteral(this);
    }

    public TextDirection getLiteralBaseDirection() {
        throw new NotLiteral(this);
    }

    public String getLiteralDatatypeURI() {
        throw new NotLiteral(this);
    }

    public RDFDatatype getLiteralDatatype() {
        throw new NotLiteral(this);
    }

    public Object getIndexingValue() {
        return this;
    }

    public String getURI() {
        throw new UnsupportedOperationException(String.valueOf(this) + " is not a URI node");
    }

    public String getNameSpace() {
        throw new UnsupportedOperationException(String.valueOf(this) + " is not a URI node");
    }

    public String getLocalName() {
        throw new UnsupportedOperationException(String.valueOf(this) + " is not a URI node");
    }

    public String getName() {
        throw new UnsupportedOperationException("this (" + String.valueOf(this.getClass()) + ") is not a variable node");
    }

    public Triple getTriple() {
        throw new UnsupportedOperationException("this (" + String.valueOf(this.getClass()) + ") is not a triple term node");
    }

    public Graph getGraph() {
        throw new UnsupportedOperationException("this (" + String.valueOf(this.getClass()) + ") is not a graph-valued node");
    }

    public boolean hasURI(String uri) {
        return false;
    }

    Node() {
    }

    public abstract boolean equals(Object var1);

    public boolean sameTermAs(Node node) {
        Objects.requireNonNull(node);
        return this.equals(node);
    }

    public boolean sameValueAs(Node node) {
        Objects.requireNonNull(node);
        return this.equals(node);
    }

    public abstract String toString();

    public abstract String toString(PrefixMapping var1);

    public abstract int hashCode();

    protected Object writeReplace() throws ObjectStreamException {
        Function<Node, Object> function = Serializer.getNodeSerializer();
        if (function == null) {
            throw new IllegalStateException("Function for Node.writeReplace not set");
        }
        return function.apply(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new IllegalStateException();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException();
    }

    public static class NotLiteral
    extends JenaException {
        public NotLiteral(Node it) {
            super(String.valueOf(it) + " is not a literal node");
        }
    }
}

