/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.mem.GraphMemFast;
import org.apache.jena.mem.GraphMemLegacy;
import org.apache.jena.mem.GraphMemRoaring;
import org.apache.jena.memvalue.GraphMemValue;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class GraphMemFactory {
    private static final Graph emptyGraph;

    private GraphMemFactory() {
    }

    public static Graph createDefaultGraph() {
        return GraphMemFactory.createDefaultGraphSameTerm();
    }

    public static Graph createGraphMemForModel() {
        GraphMemValue g = new GraphMemValue();
        return g;
    }

    public static Graph createDefaultGraphSameValue() {
        GraphMemValue g = new GraphMemValue();
        return g;
    }

    public static Graph createDefaultGraphSameTerm() {
        return GraphMemFactory.createGraphMem2();
    }

    public static Graph createGraphMemBasic() {
        return new GraphMemLegacy();
    }

    public static Graph createGraphMem2() {
        return new GraphMemFast();
    }

    public static Graph createGraphMemRoaring() {
        return new GraphMemRoaring();
    }

    public static Graph empty() {
        return emptyGraph;
    }

    static {
        JenaSystem.init();
        emptyGraph = new GraphBase(){

            @Override
            protected ExtendedIterator<Triple> graphBaseFind(Triple triplePattern) {
                return NullIterator.instance();
            }
        };
    }
}

