/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.datatypes.xsd.impl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.JenaXMLInput;
import org.apache.jena.util.JenaXMLOutput;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLiteralType
extends BaseDatatype
implements RDFDatatype {
    public static String XMLLiteralTypeURI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    public static final RDFDatatype rdfXMLLiteral = new XMLLiteralType();
    private static final String xmlWrapperTagName = "xml-literal-fragment";
    private static final String xmlWrapperTagStart = "<xml-literal-fragment>";
    private static final String xmlWrapperTagEnd = "</xml-literal-fragment>";
    private static DocumentBuilderFactory docBuilderFactory = XMLLiteralType.createDocumentBuilderFactory();

    public static boolean isXMLLiteral(RDFDatatype rdfDatatype) {
        Objects.requireNonNull(rdfDatatype);
        return XMLLiteralTypeURI.equals(rdfDatatype.getURI());
    }

    private XMLLiteralType() {
        super(XMLLiteralTypeURI);
    }

    @Override
    public boolean isEqual(LiteralLabel value1, LiteralLabel value2) {
        try {
            if (!value1.getDatatype().getURI().equals(XMLLiteralTypeURI)) {
                return false;
            }
            if (!value2.getDatatype().getURI().equals(XMLLiteralTypeURI)) {
                return false;
            }
            DocumentFragment f1 = (DocumentFragment)value1.getValue();
            DocumentFragment f2 = (DocumentFragment)value2.getValue();
            return f1.isEqualNode(f2);
        }
        catch (Exception ex) {
            throw new DatatypeFormatException();
        }
    }

    @Override
    public Object parse(String lexicalForm) {
        try {
            return XMLLiteralType.xmlLiteralValue(lexicalForm);
        }
        catch (Exception ex) {
            throw new DatatypeFormatException();
        }
    }

    public static DocumentFragment xmlLiteralValue(String string) {
        Document doc;
        DocumentBuilder builder = XMLLiteralType.newDocumentBuilder();
        builder.isNamespaceAware();
        ErrorHandlerCounting eh = new ErrorHandlerCounting();
        builder.setErrorHandler(eh);
        String xmlString = xmlWrapperTagStart + string + xmlWrapperTagEnd;
        InputSource source = new InputSource(new StringReader(xmlString));
        try {
            doc = builder.parse(source);
            if (eh.errorHappened()) {
                return null;
            }
            doc.normalizeDocument();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (SAXException ex) {
            throw Lib.runtimeException((Exception)ex);
        }
        NodeList nodeList0 = doc.getChildNodes();
        if (nodeList0.getLength() != 1) {
            throw new JenaException("XML parser did not produce exactly one child node");
        }
        NodeList nodeList = nodeList0.item(0).getChildNodes();
        DocumentFragment docFrag = doc.createDocumentFragment();
        while (nodeList.getLength() > 0) {
            Node n = nodeList.item(0);
            docFrag.appendChild(n);
        }
        return docFrag;
    }

    @Override
    public String unparse(Object value) {
        if (value instanceof DocumentFragment) {
            DocumentFragment docFrag = (DocumentFragment)value;
            return XMLLiteralType.xmlDocumentFragmentToString(docFrag);
        }
        throw new IllegalArgumentException("Value is not a ocumentFragment");
    }

    public static String xmlDocumentFragmentToString(DocumentFragment fragment) {
        StringWriter sw = new StringWriter();
        DOMSource source = new DOMSource(fragment);
        try {
            Transformer transformer = JenaXMLOutput.xmlTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult output = new StreamResult(sw);
            transformer.transform(source, output);
        }
        catch (TransformerException ex) {
            Log.error(XMLLiteralType.class, (String)"Failed to convert an org.w3c.dom.Node to a string", (Throwable)ex);
        }
        return sw.toString();
    }

    private static DocumentBuilder newDocumentBuilder() {
        try {
            return docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw Lib.runtimeException((Exception)ex);
        }
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        try {
            return JenaXMLInput.newDocumentBuilderFactory();
        }
        catch (ParserConfigurationException ex) {
            Log.error(XMLLiteralType.class, (String)"Failed to build a javax.xml.parsers.DocumentBuilderFactory", (Throwable)ex);
            return null;
        }
    }

    private static class ErrorHandlerCounting
    implements ErrorHandler {
        int warning = 0;
        int errors = 0;
        int fatalErrors = 0;

        private ErrorHandlerCounting() {
        }

        boolean errorHappened() {
            return this.errors > 0 || this.fatalErrors > 0;
        }

        @Override
        public void warning(SAXParseException exception) {
            ++this.warning;
        }

        @Override
        public void error(SAXParseException exception) {
            ++this.errors;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            ++this.fatalErrors;
            throw exception;
        }
    }
}

