/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.TerminationException;

public abstract class CmdMain
extends CmdGeneral {
    protected CmdMain(String[] args) {
        super(args);
    }

    public void mainRun() {
        this.mainRun(false, true);
    }

    public void mainRun(boolean exitOnFailure) {
        this.mainRun(exitOnFailure, true);
    }

    public void mainAndExit() {
        this.mainRun(true, true);
    }

    public int mainRun(boolean exitOnSuccess, boolean exitOnFailure) {
        try {
            this.mainMethod();
        }
        catch (TerminationException ex) {
            System.exit(ex.getCode());
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace(System.err);
            if (exitOnFailure) {
                System.exit(1);
            }
            return 1;
        }
        catch (CmdException ex) {
            if (ex.getMessage() != null && ex.getMessage().length() > 0) {
                System.err.println(ex.getMessage());
            }
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace(System.err);
            }
            if (exitOnFailure) {
                System.exit(1);
            }
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            if (exitOnFailure) {
                System.exit(2);
            }
            return 2;
        }
        if (exitOnSuccess) {
            System.exit(0);
        }
        return 0;
    }

    protected abstract void exec();

    protected final void mainMethod() {
        this.process();
        this.exec();
    }

    static {
        LogCtl.setLogging();
    }
}

