/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class ElementGroup
extends Element {
    List<Element> elements = new ArrayList<Element>();

    public void addElement(Element el) {
        this.elements.add(el);
    }

    public void addTriplePattern(Triple t) {
        this.ensureBGP().addTriple(t);
    }

    private ElementTriplesBlock ensureBGP() {
        if (this.elements.size() == 0) {
            return this.pushBGP();
        }
        Element top = this.top();
        Object bgp = null;
        if (top instanceof ElementTriplesBlock) {
            return (ElementTriplesBlock)top;
        }
        return this.pushBGP();
    }

    private ElementTriplesBlock pushBGP() {
        ElementTriplesBlock bgp = new ElementTriplesBlock();
        this.elements.add(bgp);
        return bgp;
    }

    private void setTop(Element el) {
        this.elements.set(this.elements.size() - 1, el);
    }

    private Element top() {
        return this.elements.get(this.elements.size() - 1);
    }

    public int mark() {
        return this.elements.size();
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        return this.elements.size() == 0;
    }

    public int size() {
        return this.elements.size();
    }

    public Element get(int idx) {
        return this.elements.get(idx);
    }

    public Element getLast() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(this.elements.size() - 1);
    }

    @Override
    public int hashCode() {
        int calcHashCode = 162;
        return calcHashCode ^= this.getElements().hashCode();
    }

    @Override
    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if (el2 == null) {
            return false;
        }
        if (!(el2 instanceof ElementGroup)) {
            return false;
        }
        ElementGroup eg2 = (ElementGroup)el2;
        if (this.getElements().size() != eg2.getElements().size()) {
            return false;
        }
        for (int i = 0; i < this.getElements().size(); ++i) {
            Element e2;
            Element e1 = this.getElements().get(i);
            if (e1.equalTo(e2 = eg2.getElements().get(i), isoMap)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

