/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.Timeouts;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.modify.UpdateEngine;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateSink;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class UpdateProcessorBase
implements UpdateProcessor {
    protected final UpdateRequest request;
    protected final DatasetGraph datasetGraph;
    protected final UpdateEngineFactory factory;
    protected final Context context;
    protected final Timeouts.Timeout timeout;

    public UpdateProcessorBase(UpdateRequest request, DatasetGraph datasetGraph, Binding inputBinding, Context context2, UpdateEngineFactory factory, Timeouts.Timeout timeout) {
        this.request = request;
        this.datasetGraph = datasetGraph;
        this.context = context2;
        Context.setCurrentDateTime(this.context);
        this.factory = factory;
        this.timeout = timeout;
        Context.getOrSetCancelSignal(this.context);
        if (timeout != null) {
            Timeouts.setUpdateTimeout(context2, timeout);
        }
    }

    @Override
    public void execute() {
        UpdateEngine uProc = this.factory.create(this.datasetGraph, this.context);
        uProc.startRequest();
        try {
            UpdateSink sink = uProc.getUpdateSink();
            Iter.sendToSink(this.request.iterator(), (Sink)sink);
        }
        finally {
            uProc.finishRequest();
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void abort() {
        AtomicBoolean cancelSignal = Context.getCancelSignal(this.context);
        if (cancelSignal != null) {
            cancelSignal.set(true);
        }
    }
}

