/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.sparql.expr.NVDatatypes;

class NVOps {
    private static final Map<RDFDatatype, Predicate<XMLGregorianCalendar>> TEMPORAL_VALIDATE = Map.ofEntries(Map.entry(NVDatatypes.XSDdateTime, gCal -> NVOps.checkDateFields(gCal, true) && NVOps.checkTimeFields(gCal, true)), Map.entry(NVDatatypes.XSDdateTimeStamp, gCal -> NVOps.checkDateFields(gCal, true) && NVOps.checkTimeFields(gCal, true) && NVOps.checkTimezoneField(gCal, true)), Map.entry(NVDatatypes.XSDdate, gCal -> NVOps.checkDateFields(gCal, true) && NVOps.checkTimeFields(gCal, false)), Map.entry(NVDatatypes.XSDtime, gCal -> NVOps.checkDateFields(gCal, false) && NVOps.checkTimeFields(gCal, true)), Map.entry(NVDatatypes.XSDgYear, gCal -> NVOps.checkDateFields(gCal, true, false, false) && NVOps.checkTimeFields(gCal, false)), Map.entry(NVDatatypes.XSDgYearMonth, gCal -> NVOps.checkDateFields(gCal, true, true, false) && NVOps.checkTimeFields(gCal, false)), Map.entry(NVDatatypes.XSDgMonth, gCal -> NVOps.checkDateFields(gCal, false, true, false) && NVOps.checkTimeFields(gCal, false)), Map.entry(NVDatatypes.XSDgMonthDay, gCal -> NVOps.checkDateFields(gCal, false, true, true) && NVOps.checkTimeFields(gCal, false)), Map.entry(NVDatatypes.XSDgDay, gCal -> NVOps.checkDateFields(gCal, false, false, true) && NVOps.checkTimeFields(gCal, false)));
    private static final Map<RDFDatatype, Predicate<Duration>> DURATION_VALIDATE = Map.ofEntries(Map.entry(NVDatatypes.XSDduration, dur -> true), Map.entry(NVDatatypes.XSDdayTimeDuration, dur -> NVOps.isDayTimeDuration(dur)), Map.entry(NVDatatypes.XSDyearMonthDuration, dur -> NVOps.isYearMonthDuration(dur)));

    NVOps() {
    }

    static boolean checkCalendarInstance(XMLGregorianCalendar gCal, RDFDatatype xsdDatatype) {
        Objects.requireNonNull(xsdDatatype);
        Predicate<XMLGregorianCalendar> predicate = TEMPORAL_VALIDATE.get(xsdDatatype);
        return predicate.test(gCal);
    }

    private static boolean checkFields(XMLGregorianCalendar gCal, boolean yearField, boolean monthField, boolean dayField, boolean hourField, boolean minuteField, boolean secondField) {
        return NVOps.checkDateFields(gCal, yearField, monthField, dayField) && NVOps.checkTimeFields(gCal, hourField, minuteField, secondField);
    }

    private static boolean checkDateFields(XMLGregorianCalendar gCal, boolean present) {
        return NVOps.checkDateFields(gCal, present, present, present);
    }

    private static boolean checkDateFields(XMLGregorianCalendar gCal, boolean yearField, boolean monthField, boolean dayField) {
        if (!NVOps.checkTemporalField(gCal.getYear(), yearField)) {
            return false;
        }
        if (!NVOps.checkTemporalField(gCal.getMonth(), monthField)) {
            return false;
        }
        return NVOps.checkTemporalField(gCal.getDay(), dayField);
    }

    private static boolean checkTimeFields(XMLGregorianCalendar gCal, boolean present) {
        return NVOps.checkTimeFields(gCal, present, present, present);
    }

    private static boolean checkTimeFields(XMLGregorianCalendar gCal, boolean hourField, boolean minuteField, boolean secondField) {
        if (!NVOps.checkTemporalField(gCal.getHour(), hourField)) {
            return false;
        }
        if (!NVOps.checkTemporalField(gCal.getMinute(), minuteField)) {
            return false;
        }
        return NVOps.checkTemporalField(gCal.getSecond(), secondField);
    }

    private static boolean checkTimezoneField(XMLGregorianCalendar gCal, boolean timezonePresent) {
        return NVOps.checkTemporalField(gCal.getTimezone(), timezonePresent);
    }

    private static boolean checkTemporalField(int fieldValue, boolean isSet) {
        return fieldValue != Integer.MIN_VALUE == isSet;
    }

    static boolean checkDurationInstance(Duration duration, RDFDatatype xsdDatatype) {
        Objects.requireNonNull(xsdDatatype);
        Predicate<Duration> predicate = DURATION_VALIDATE.get(xsdDatatype);
        return predicate.test(duration);
    }

    static boolean isDayTimeDuration(Duration duration) {
        return NVOps.checkDurationField(duration, DatatypeConstants.YEARS, false) && NVOps.checkDurationField(duration, DatatypeConstants.MONTHS, false);
    }

    static boolean isYearMonthDuration(Duration duration) {
        return NVOps.checkDurationField(duration, DatatypeConstants.DAYS, false) && NVOps.checkDurationField(duration, DatatypeConstants.HOURS, false) && NVOps.checkDurationField(duration, DatatypeConstants.MINUTES, false) && NVOps.checkDurationField(duration, DatatypeConstants.SECONDS, false);
    }

    private static boolean checkDurationField(Duration duration, DatatypeConstants.Field field, boolean isSet) {
        return duration.isSet(field) == isSet;
    }
}

