/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system.jsonld;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.serialization.QuadsToJsonld;
import com.apicatalog.rdf.api.RdfConsumerException;
import jakarta.json.JsonArray;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

public class JenaToTitanium {
    public static JsonArray convert(DatasetGraph dataset, JsonLdOptions opts) throws JsonLdError {
        QuadsToJsonld consumer = JsonLd.fromRdf().options(opts).mode(JsonLdVersion.V1_1);
        dataset.stream().forEach(quad -> {
            String s = JenaToTitanium.resource(quad.getSubject());
            String p = JenaToTitanium.resource(quad.getPredicate());
            String g = JenaToTitanium.resourceGraphName(quad.getGraph());
            Node obj = quad.getObject();
            if (obj.isURI() || obj.isBlank()) {
                String o = JenaToTitanium.resource(obj);
                try {
                    consumer.quad(s, p, o, null, null, null, g);
                }
                catch (RdfConsumerException ex) {
                    throw new JenaTitaniumException("Exception while translating to JSON-LD", ex);
                }
            } else if (obj.isLiteral()) {
                String lex = obj.getLiteralLexicalForm();
                String datatype = obj.getLiteralDatatypeURI();
                String lang = obj.getLiteralLanguage();
                if (lang.isEmpty()) {
                    lang = null;
                }
                String dir = null;
                if (obj.getLiteralBaseDirection() != null) {
                    dir = obj.getLiteralBaseDirection().toString();
                }
                try {
                    consumer.quad(s, p, lex, datatype, lang, dir, g);
                }
                catch (RdfConsumerException ex) {
                    throw new JenaTitaniumException("Exception while translating to JSON-LD", ex);
                }
            } else {
                if (obj.isTripleTerm()) {
                    throw new JenaTitaniumException("Triple terms not supported for JSON-LD");
                }
                throw new JenaTitaniumException("Encountered unexpected term: " + String.valueOf(obj));
            }
        });
        return consumer.toJsonLd();
    }

    private static String resourceGraphName(Node gn) {
        if (gn == null || Quad.isDefaultGraph(gn)) {
            return null;
        }
        return JenaToTitanium.resource(gn);
    }

    private static String resource(Node term) {
        if (term.isBlank()) {
            return "_:" + term.getBlankNodeLabel();
        }
        if (term.isURI()) {
            return term.getURI();
        }
        throw new JenaTitaniumException("Not a URI or a blank node");
    }

    static class JenaTitaniumException
    extends JenaException {
        JenaTitaniumException(String msg) {
            super(msg);
        }

        JenaTitaniumException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

