/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.lang.LangParserLib;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.vocabulary.RDF;

public class LangParserBase {
    protected final Node XSD_TRUE = NodeConst.nodeTrue;
    protected final Node XSD_FALSE = NodeConst.nodeFalse;
    protected final Node nRDFtype = NodeConst.nodeRDFType;
    protected final Node nRDFnil = NodeConst.nodeNil;
    protected final Node nRDFfirst = NodeConst.nodeFirst;
    protected final Node nRDFrest = NodeConst.nodeRest;
    protected final Node nRDFsubject = RDF.Nodes.subject;
    protected final Node nRDFpredicate = RDF.Nodes.predicate;
    protected final Node nRDFobject = RDF.Nodes.object;
    protected final Node nRDFreifies = RDF.Nodes.reifies;
    protected StreamRDF stream;
    protected ParserProfile profile;
    private Node annotationReifierId = null;

    public void setProfile(ParserProfile profile) {
        this.profile = profile;
    }

    public void setDest(StreamRDF stream) {
        this.stream = stream;
    }

    protected String canonicalPrefix(String prefix, int line, int column) {
        if (prefix.endsWith(":")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    protected Node createURI(String iriStr, int line, int column) {
        LangParserBase.checkRDFString(iriStr, line, column);
        return this.profile.createURI(iriStr, (long)line, (long)column);
    }

    protected Node createBNode(int line, int column) {
        return this.profile.createBlankNode(null, line, column);
    }

    protected Node createBNode(String label, int line, int column) {
        return this.profile.createBlankNode(null, label, line, column);
    }

    protected Node createListNode(int line, int column) {
        return this.createBNode(line, column);
    }

    protected static void checkRDFString(String string, int line, int column) {
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (!Character.isValidCodePoint(ch)) {
                throw new RiotParseException(String.format("Illegal code point in \\U sequence value: 0x%08X", Character.valueOf(ch)), line, column);
            }
            if (Character.isHighSurrogate(ch)) {
                if (++i == string.length()) {
                    throw new RiotParseException("Bad surrogate pair (end of string)", line, column);
                }
                char ch1 = string.charAt(i);
                if (Character.isLowSurrogate(ch1)) continue;
                throw new RiotParseException("Bad surrogate pair (high surrogate not followed by low surrogate)", line, column);
            }
            if (!Character.isLowSurrogate(ch)) continue;
            throw new RiotParseException("Bad surrogate pair (low surrogate without high surrogate)", line, column);
        }
    }

    protected Node createLiteral(String lexicalForm, String langTag, String datatypeURI, int line, int column) {
        Node n = null;
        if (datatypeURI != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
            n = this.profile.createTypedLiteral(lexicalForm, dType, line, column);
        } else {
            n = langTag != null && !langTag.isEmpty() ? this.profile.createLangLiteral(lexicalForm, langTag, line, column) : this.profile.createStringLiteral(lexicalForm, line, column);
        }
        return n;
    }

    protected Node createTripleTerm(Node s, Node p, Node o, int line, int column) {
        return this.profile.createTripleTerm(s, p, o, line, column);
    }

    protected Node createLiteralInteger(String lexicalForm, int line, int column) {
        return this.profile.createTypedLiteral(lexicalForm, (RDFDatatype)XSDDatatype.XSDinteger, line, column);
    }

    protected Node createLiteralDecimal(String lexicalForm, int line, int column) {
        return this.profile.createTypedLiteral(lexicalForm, (RDFDatatype)XSDDatatype.XSDdecimal, line, column);
    }

    protected Node createLiteralDouble(String lexicalForm, int line, int column) {
        return this.profile.createTypedLiteral(lexicalForm, (RDFDatatype)XSDDatatype.XSDdouble, line, column);
    }

    protected Var createVariable(String varName, int line, int column) {
        varName = varName.substring(1);
        return Var.alloc(varName);
    }

    protected String resolvePName(String pname, int line, int column) {
        int idx = pname.indexOf(58);
        String prefix = pname.substring(0, idx);
        String localPart = pname.substring(idx + 1);
        localPart = LangParserLib.unescapePName(localPart, line, column);
        String expansion = this.profile.getPrefixMap().expand(prefix, localPart);
        if (expansion == null) {
            if (ARQ.isTrue(ARQ.fixupUndefinedPrefixes)) {
                return RiotLib.fixupPrefixIRI(prefix, localPart);
            }
            this.profile.getErrorHandler().fatal("Undefined prefix: " + prefix, line, column);
        }
        return expansion;
    }

    protected String resolveQuotedIRI(String iriStr, int line, int column) {
        iriStr = LangParserLib.stripQuotes(iriStr);
        iriStr = this.unescapeIRI(iriStr);
        LangParserBase.checkRDFString(iriStr, line, column);
        if (iriStr.contains("<") || iriStr.contains(">")) {
            throw new RiotParseException("Illegal character '<' or '>' in IRI: '" + iriStr + "'", line, column);
        }
        return this.profile.resolveIRI(iriStr, line, column);
    }

    protected void setBase(String iri, int line, int column) {
        this.profile.setBaseIRI(iri);
        this.stream.base(iri);
    }

    protected void setPrefix(String prefix, String iri, int line, int column) {
        prefix = this.canonicalPrefix(prefix, line, column);
        this.profile.getPrefixMap().add(prefix, iri);
        this.stream.prefix(prefix, iri);
    }

    protected void declareVersion(String version2, int line, int column) {
        this.stream.version(version2);
    }

    @Deprecated(forRemoval=true)
    protected void emitTriple(int line, int column, Node s, Node p, Node o) {
        this.emitTriple(s, p, o, line, column);
    }

    protected void emitTriple(Node s, Node p, Node o, int line, int column) {
        this.stream.triple(Triple.create((Node)s, (Node)p, (Node)o));
    }

    @Deprecated(forRemoval=true)
    protected Node emitTripleReifier(int line, int column, Node reifierId, Node s, Node p, Node o) {
        return this.emitTripleReifier(reifierId, s, p, o, line, column);
    }

    protected Node emitTripleReifier(Node reifierId, Node s, Node p, Node o, int line, int column) {
        Node tripleTerm = this.createTripleTerm(s, p, o, line, column);
        if (reifierId == null) {
            reifierId = this.createBNode(line, column);
        }
        Triple reifiedTriple = Triple.create((Node)reifierId, (Node)this.nRDFreifies, (Node)tripleTerm);
        this.stream.triple(reifiedTriple);
        return reifierId;
    }

    protected void setReifierId(Node reifId) {
        this.annotationReifierId = reifId;
    }

    protected Node getOrAllocReifierId(Node s, Node p, Node o, int line, int column) {
        if (this.annotationReifierId != null) {
            return this.annotationReifierId;
        }
        Node reifierId = this.createBNode(line, column);
        this.emitTripleReifier(line, column, reifierId, s, p, o);
        return reifierId;
    }

    protected void clearReifierId() {
        this.annotationReifierId = null;
    }

    protected String unescapeIRI(String iriStr) {
        try {
            return EscapeStr.unescape((String)iriStr, (char)'\\', (boolean)true);
        }
        catch (AtlasException ex) {
            throw new RiotException(ex.getMessage());
        }
    }

    protected void listStart(int line, int column) {
    }

    protected void listTriple(int line, int column, Node s, Node p, Node o) {
        this.emitTriple(line, column, s, p, o);
    }

    protected void listFinish(int line, int column) {
    }
}

