/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.irix.IRIs;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.jsonld.TitaniumJsonLdOptions;
import org.apache.jena.riot.system.jsonld.TitaniumToJena;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class LangJSONLD11
implements ReaderRIOT {
    private final ErrorHandler errorHandler;
    private final ParserProfile profile;
    private static final String SYMBOLS_NS = "http://jena.apache.org/riot/jsonld#";
    public static final Symbol JSONLD_OPTIONS = SystemARQ.allocSymbol("http://jena.apache.org/riot/jsonld#", "options");

    public LangJSONLD11(Lang language, ParserProfile profile, ErrorHandler errorHandler) {
        this.profile = profile;
        this.errorHandler = errorHandler;
    }

    @Override
    public void read(InputStream input, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        try {
            JsonDocument document = JsonDocument.of((InputStream)input);
            this.read((Document)document, baseURI, output, context2);
        }
        catch (JsonLdError ex) {
            this.handleJsonLdError(ex);
        }
        catch (Exception ex) {
            this.errorHandler.error(ex.getMessage(), -1L, -1L);
            throw new RiotException(ex);
        }
    }

    private void handleJsonLdError(JsonLdError ex) {
        JsonLdError ex2;
        Throwable cause = ex.getCause();
        if (cause instanceof JsonParsingException) {
            JsonParsingException exp = (JsonParsingException)cause;
            JsonLocation loc = exp.getLocation();
            this.errorHandler.error(ex.getMessage(), loc.getLineNumber(), loc.getColumnNumber());
        } else if (cause instanceof JsonLdError && ex != (ex2 = (JsonLdError)cause)) {
            this.errorHandler.error(ex2.getMessage(), -1L, -1L);
        }
        throw new RiotException(ex);
    }

    @Override
    public void read(Reader in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        try {
            JsonDocument document = JsonDocument.of((Reader)in);
            this.read((Document)document, baseURI, output, context2);
        }
        catch (JsonLdError ex) {
            this.handleJsonLdError(ex);
        }
        catch (Exception ex) {
            this.errorHandler.error(ex.getMessage(), -1L, -1L);
            throw new RiotException(ex);
        }
    }

    private void read(Document document, String baseURI, StreamRDF output, Context context2) throws JsonLdError {
        JsonLdOptions opts = TitaniumJsonLdOptions.get(baseURI, context2);
        LangJSONLD11.extractPrefixes(document, output::prefix);
        TitaniumToJena.convert(document, opts, output, this.profile);
    }

    private static void extractPrefixes(Document document, BiConsumer<String, String> action) {
        try {
            JsonStructure jsonStructure = document.getJsonContent().orElse(null);
            if (jsonStructure == null) {
                return;
            }
            LangJSONLD11.extractPrefixesValue((JsonValue)jsonStructure, action);
        }
        catch (Throwable ex) {
            Log.warn(LangJSONLD11.class, (String)("Unexpected problem while extracting prefixes: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private static void extractPrefixesValue(JsonValue jsonValue, BiConsumer<String, String> action) {
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                LangJSONLD11.extractPrefixesArray(jsonValue.asJsonArray(), action);
                break;
            }
            case OBJECT: {
                LangJSONLD11.extractPrefixesObject(jsonValue.asJsonObject(), action);
                break;
            }
        }
    }

    private static void extractPrefixesArray(JsonArray jsonArray, BiConsumer<String, String> action) {
        jsonArray.forEach(jv -> LangJSONLD11.extractPrefixesValue(jv, action));
    }

    private static void extractPrefixesObject(JsonObject jsonObject, BiConsumer<String, String> action) {
        JsonValue contextValue = (JsonValue)jsonObject.get((Object)"@context");
        if (contextValue == null) {
            return;
        }
        switch (contextValue.getValueType()) {
            case ARRAY: {
                LangJSONLD11.extractPrefixesContextArray(contextValue.asJsonArray(), action);
                break;
            }
            case OBJECT: {
                LangJSONLD11.extractPrefixesContextDefinition(contextValue.asJsonObject(), action);
                break;
            }
        }
    }

    private static void extractPrefixesContextArray(JsonArray jsonArray, BiConsumer<String, String> action) {
        jsonArray.forEach(cxtArrayEntry -> {
            switch (cxtArrayEntry.getValueType()) {
                case OBJECT: {
                    LangJSONLD11.extractPrefixesContextDefinition(cxtArrayEntry.asJsonObject(), action);
                    break;
                }
            }
        });
    }

    private static void extractPrefixesContextDefinition(JsonObject jCxt, BiConsumer<String, String> action) {
        Set keys = jCxt.keySet();
        keys.stream().forEach(k -> {
            JsonValue jValue = (JsonValue)jCxt.get(k);
            if (JsonValue.ValueType.STRING != jValue.getValueType()) {
                return;
            }
            String prefix = k;
            if ("@vocab".equals(k)) {
                prefix = "";
            } else if (k.startsWith("@")) {
                return;
            }
            String uri = ((JsonString)JsonString.class.cast(jValue)).getString();
            if (uri.endsWith("#") || uri.endsWith("/") || uri.endsWith(":")) {
                if (IRIs.check((String)uri)) {
                    action.accept(prefix, uri);
                }
                return;
            }
        });
    }
}

