/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.stream.Stream;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;

public interface OntProperty
extends OntObject {
    public Property asProperty();

    public Stream<? extends OntProperty> subProperties(boolean var1);

    public Stream<? extends OntProperty> superProperties(boolean var1);

    public Stream<? extends Resource> domains();

    public Stream<? extends Resource> ranges();

    public Stream<OntClass> declaringClasses(boolean var1);

    default public Stream<? extends OntProperty> subProperties() {
        return this.subProperties(false);
    }

    default public Stream<? extends OntProperty> superProperties() {
        return this.superProperties(false);
    }

    default public boolean hasSubProperty(OntProperty property, boolean direct) {
        return property.hasSuperProperty(this, direct);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean hasSuperProperty(OntProperty property, boolean direct) {
        if (this.equals(property)) return true;
        if (!this.superProperties(direct).anyMatch(arg_0 -> ((OntProperty)property).equals(arg_0))) return false;
        return true;
    }

    default public OntStatement addSubPropertyOfStatement(Resource property) {
        return this.addStatement(RDFS.subPropertyOf, (RDFNode)property);
    }

    default public OntStatement addRangeStatement(Resource range) {
        return this.addStatement(RDFS.range, (RDFNode)range);
    }

    default public OntStatement addDomainStatement(Resource domain) {
        return this.addStatement(RDFS.domain, (RDFNode)domain);
    }

    default public OntProperty removeDomain(Resource domain) {
        this.remove(RDFS.domain, (RDFNode)domain);
        return this;
    }

    default public OntProperty removeRange(Resource range) {
        this.remove(RDFS.range, (RDFNode)range);
        return this;
    }

    default public OntProperty removeSuperProperty(Resource property) {
        this.remove(RDFS.subPropertyOf, (RDFNode)property);
        return this;
    }

    default public OntProperty removeSubProperty(Resource property) {
        this.getModel().statements(property, RDFS.subPropertyOf, (RDFNode)this).toList().forEach(s -> this.getModel().remove(s.clearAnnotations()));
        return this;
    }
}

