/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.quota;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.Optional;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.backends.jpa.TransactionRunner;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.jpa.quota.model.JpaCurrentQuota;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import reactor.core.publisher.Mono;

public class JpaCurrentQuotaManager
implements CurrentQuotaManager {
    public static final long NO_MESSAGES = 0L;
    public static final long NO_STORED_BYTES = 0L;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionRunner transactionRunner;

    @Inject
    public JpaCurrentQuotaManager(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.transactionRunner = new TransactionRunner(entityManagerFactory);
    }

    public Mono<QuotaCountUsage> getCurrentMessageCount(QuotaRoot quotaRoot) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return Mono.fromCallable(() -> Optional.ofNullable(this.retrieveUserQuota(entityManager, quotaRoot)).map(JpaCurrentQuota::getMessageCount).orElse(QuotaCountUsage.count((long)0L))).doFinally(any -> EntityManagerUtils.safelyClose((EntityManager)entityManager));
    }

    public Mono<QuotaSizeUsage> getCurrentStorage(QuotaRoot quotaRoot) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return Mono.fromCallable(() -> Optional.ofNullable(this.retrieveUserQuota(entityManager, quotaRoot)).map(JpaCurrentQuota::getSize).orElse(QuotaSizeUsage.size((long)0L))).doFinally(any -> EntityManagerUtils.safelyClose((EntityManager)entityManager));
    }

    public Mono<CurrentQuotas> getCurrentQuotas(QuotaRoot quotaRoot) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return Mono.fromCallable(() -> Optional.ofNullable(this.retrieveUserQuota(entityManager, quotaRoot)).map(jpaCurrentQuota -> new CurrentQuotas(jpaCurrentQuota.getMessageCount(), jpaCurrentQuota.getSize())).orElse(CurrentQuotas.emptyQuotas())).doFinally(any -> EntityManagerUtils.safelyClose((EntityManager)entityManager));
    }

    public Mono<Void> increase(QuotaOperation quotaOperation) {
        return Mono.fromRunnable(() -> this.transactionRunner.run(entityManager -> {
            QuotaRoot quotaRoot = quotaOperation.quotaRoot();
            JpaCurrentQuota jpaCurrentQuota = Optional.ofNullable(this.retrieveUserQuota((EntityManager)entityManager, quotaRoot)).orElse(new JpaCurrentQuota(quotaRoot.getValue(), 0L, 0L));
            entityManager.merge((Object)new JpaCurrentQuota(quotaRoot.getValue(), jpaCurrentQuota.getMessageCount().asLong() + quotaOperation.count().asLong(), jpaCurrentQuota.getSize().asLong() + quotaOperation.size().asLong()));
        }));
    }

    public Mono<Void> decrease(QuotaOperation quotaOperation) {
        return Mono.fromRunnable(() -> this.transactionRunner.run(entityManager -> {
            QuotaRoot quotaRoot = quotaOperation.quotaRoot();
            JpaCurrentQuota jpaCurrentQuota = Optional.ofNullable(this.retrieveUserQuota((EntityManager)entityManager, quotaRoot)).orElse(new JpaCurrentQuota(quotaRoot.getValue(), 0L, 0L));
            entityManager.merge((Object)new JpaCurrentQuota(quotaRoot.getValue(), jpaCurrentQuota.getMessageCount().asLong() - quotaOperation.count().asLong(), jpaCurrentQuota.getSize().asLong() - quotaOperation.size().asLong()));
        }));
    }

    public Mono<Void> setCurrentQuotas(QuotaOperation quotaOperation) {
        return Mono.fromCallable(() -> this.getCurrentQuotas(quotaOperation.quotaRoot())).flatMap(storedQuotas -> Mono.fromRunnable(() -> this.transactionRunner.run(entityManager -> {
            if (!storedQuotas.equals(CurrentQuotas.from((QuotaOperation)quotaOperation))) {
                entityManager.merge((Object)new JpaCurrentQuota(quotaOperation.quotaRoot().getValue(), quotaOperation.count().asLong(), quotaOperation.size().asLong()));
            }
        })));
    }

    private JpaCurrentQuota retrieveUserQuota(EntityManager entityManager, QuotaRoot quotaRoot) {
        return (JpaCurrentQuota)entityManager.find(JpaCurrentQuota.class, (Object)quotaRoot.getValue());
    }
}

