/*
 * Decompiled with CFR 0.152.
 */
package spark.embeddedserver.jetty.websocket;

import java.util.Objects;
import org.eclipse.jetty.ee10.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.ee10.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import spark.embeddedserver.jetty.websocket.WebSocketHandlerWrapper;

public class WebSocketCreatorFactory {
    public static WebSocketCreator create(WebSocketHandlerWrapper handlerWrapper) {
        return new SparkWebSocketCreator(handlerWrapper.getHandler());
    }

    public static JettyWebSocketCreator createWS(WebSocketHandlerWrapper handlerWrapper) {
        return new SparkWebSocketCreator(handlerWrapper.getHandler());
    }

    static class SparkWebSocketCreator
    implements WebSocketCreator,
    JettyWebSocketCreator {
        private final Object handler;

        private SparkWebSocketCreator(Object handler) {
            this.handler = Objects.requireNonNull(handler, "handler cannot be null");
        }

        Object getHandler() {
            return this.handler;
        }

        public Object createWebSocket(JettyServerUpgradeRequest jettyServerUpgradeRequest, JettyServerUpgradeResponse jettyServerUpgradeResponse) {
            return this.handler;
        }

        public Object createWebSocket(ServerUpgradeRequest serverUpgradeRequest, ServerUpgradeResponse serverUpgradeResponse, Callback callback) {
            return this.handler;
        }
    }
}

