/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.arc.BeanCreator;
import io.quarkus.arc.SyntheticCreationalContext;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.SmallRyeConfig;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperties;

public class ConfigMappingCreator
implements BeanCreator<Object> {
    public Object create(SyntheticCreationalContext<Object> context) {
        InjectionPoint injectionPoint = (InjectionPoint)context.getInjectedReference(InjectionPoint.class, new Annotation[0]);
        if (injectionPoint == null) {
            throw new IllegalStateException("No current injection point found");
        }
        Class interfaceType = (Class)context.getParams().get("type");
        String prefix = (String)context.getParams().get("prefix");
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
        return config.getConfigMapping(interfaceType, ConfigMappingCreator.getPrefixFromInjectionPoint(injectionPoint).orElse(prefix));
    }

    private static Optional<String> getPrefixFromInjectionPoint(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated != null) {
            ConfigMapping configMapping = (ConfigMapping)annotated.getAnnotation(ConfigMapping.class);
            if (configMapping != null && !configMapping.prefix().isEmpty()) {
                return Optional.of(configMapping.prefix());
            }
            ConfigProperties configProperties = (ConfigProperties)annotated.getAnnotation(ConfigProperties.class);
            if (configProperties != null && !"org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix".equals(configProperties.prefix())) {
                return Optional.of(configProperties.prefix());
            }
        }
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            ConfigProperties configPropertiesQualifier;
            if (!(qualifier instanceof ConfigProperties) || "org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix".equals((configPropertiesQualifier = (ConfigProperties)qualifier).prefix())) continue;
            return Optional.of(configPropertiesQualifier.prefix());
        }
        return Optional.empty();
    }
}

