/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisEvent;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.ChangeTrackingResult;
import org.apache.polaris.core.persistence.dao.entity.CreateCatalogResult;
import org.apache.polaris.core.persistence.dao.entity.CreatePrincipalResult;
import org.apache.polaris.core.persistence.dao.entity.DropEntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntitiesResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntityWithPath;
import org.apache.polaris.core.persistence.dao.entity.GenerateEntityIdResult;
import org.apache.polaris.core.persistence.dao.entity.ListEntitiesResult;
import org.apache.polaris.core.persistence.dao.entity.LoadGrantsResult;
import org.apache.polaris.core.persistence.dao.entity.LoadPolicyMappingsResult;
import org.apache.polaris.core.persistence.dao.entity.PolicyAttachmentResult;
import org.apache.polaris.core.persistence.dao.entity.PrincipalSecretsResult;
import org.apache.polaris.core.persistence.dao.entity.PrivilegeResult;
import org.apache.polaris.core.persistence.dao.entity.ResolvedEntitiesResult;
import org.apache.polaris.core.persistence.dao.entity.ResolvedEntityResult;
import org.apache.polaris.core.persistence.dao.entity.ScopedCredentialsResult;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.core.policy.PolicyType;

public class TransactionWorkspaceMetaStoreManager
implements PolarisMetaStoreManager {
    private final PolarisDiagnostics diagnostics;
    private final PolarisMetaStoreManager delegate;
    private final List<EntityWithPath> pendingUpdates = new ArrayList<EntityWithPath>();

    public TransactionWorkspaceMetaStoreManager(PolarisDiagnostics diagnostics, PolarisMetaStoreManager delegate) {
        this.diagnostics = diagnostics;
        this.delegate = delegate;
    }

    private RuntimeException illegalMethodError(String methodName) {
        return this.diagnostics.fail("illegal_method_in_transaction_workspace", methodName, new Object[0]);
    }

    public List<EntityWithPath> getPendingUpdates() {
        return ImmutableList.copyOf(this.pendingUpdates);
    }

    @Override
    @Nonnull
    public BaseResult bootstrapPolarisService(@Nonnull PolarisCallContext callCtx) {
        throw this.illegalMethodError("bootstrapPolarisService");
    }

    @Override
    @Nonnull
    public BaseResult purge(@Nonnull PolarisCallContext callCtx) {
        throw this.illegalMethodError("purge");
    }

    @Override
    @Nonnull
    public EntityResult readEntityByName(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull String name) {
        throw this.illegalMethodError("readEntityByName");
    }

    @Override
    @Nonnull
    public ListEntitiesResult listEntities(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        throw this.illegalMethodError("listEntities");
    }

    @Override
    @Nonnull
    public Page<PolarisBaseEntity> listFullEntities(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        throw this.illegalMethodError("listFullEntities");
    }

    @Override
    @Nonnull
    public GenerateEntityIdResult generateNewEntityId(@Nonnull PolarisCallContext callCtx) {
        throw this.illegalMethodError("generateNewEntityId");
    }

    @Override
    @Nonnull
    public CreatePrincipalResult createPrincipal(@Nonnull PolarisCallContext callCtx, @Nonnull PrincipalEntity principal) {
        throw this.illegalMethodError("createPrincipal");
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult loadPrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId) {
        throw this.illegalMethodError("loadPrincipalSecrets");
    }

    @Override
    public void deletePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId) {
        throw this.illegalMethodError("deletePrincipalSecrets");
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult rotatePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId, boolean reset, @Nonnull String oldSecretHash) {
        throw this.illegalMethodError("rotatePrincipalSecrets");
    }

    @Override
    @Nonnull
    public PrincipalSecretsResult resetPrincipalSecrets(@Nonnull PolarisCallContext callCtx, long principalId, @Nonnull String resolvedClientId, String customClientSecret) {
        throw this.illegalMethodError("resetPrincipalSecrets");
    }

    @Override
    @Nonnull
    public CreateCatalogResult createCatalog(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity catalog, @Nonnull List<PolarisEntityCore> principalRoles) {
        throw this.illegalMethodError("createCatalog");
    }

    @Override
    @Nonnull
    public EntityResult createEntityIfNotExists(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        throw this.illegalMethodError("createEntityIfNotExists");
    }

    @Override
    @Nonnull
    public EntitiesResult createEntitiesIfNotExist(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull List<? extends PolarisBaseEntity> entities) {
        throw this.illegalMethodError("createEntitiesIfNotExist");
    }

    @Override
    @Nonnull
    public EntityResult updateEntityPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entity) {
        this.pendingUpdates.add(new EntityWithPath(catalogPath, entity));
        return new EntityResult(entity);
    }

    @Override
    @Nonnull
    public EntitiesResult updateEntitiesPropertiesIfNotChanged(@Nonnull PolarisCallContext callCtx, @Nonnull List<EntityWithPath> entities) {
        throw this.illegalMethodError("updateEntitiesPropertiesIfNotChanged");
    }

    @Override
    @Nonnull
    public EntityResult renameEntity(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entityToRename, @Nullable List<PolarisEntityCore> newCatalogPath, @Nonnull PolarisEntity renamedEntity) {
        throw this.illegalMethodError("renameEntity");
    }

    @Override
    @Nonnull
    public DropEntityResult dropEntityIfExists(@Nonnull PolarisCallContext callCtx, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisBaseEntity entityToDrop, @Nullable Map<String, String> cleanupProperties, boolean cleanup) {
        throw this.illegalMethodError("dropEntityIfExists");
    }

    @Override
    @Nonnull
    public PrivilegeResult grantUsageOnRoleToGrantee(@Nonnull PolarisCallContext callCtx, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        throw this.illegalMethodError("grantUsageOnRoleToGrantee");
    }

    @Override
    @Nonnull
    public PrivilegeResult revokeUsageOnRoleFromGrantee(@Nonnull PolarisCallContext callCtx, @Nullable PolarisEntityCore catalog, @Nonnull PolarisEntityCore role, @Nonnull PolarisEntityCore grantee) {
        throw this.illegalMethodError("revokeUsageOnRoleFromGrantee");
    }

    @Override
    @Nonnull
    public PrivilegeResult grantPrivilegeOnSecurableToRole(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege privilege) {
        throw this.illegalMethodError("grantPrivilegeOnSecurableToRole");
    }

    @Override
    @Nonnull
    public PrivilegeResult revokePrivilegeOnSecurableFromRole(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore grantee, @Nullable List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore securable, @Nonnull PolarisPrivilege privilege) {
        throw this.illegalMethodError("revokePrivilegeOnSecurableFromRole");
    }

    @Override
    @Nonnull
    public LoadGrantsResult loadGrantsOnSecurable(@Nonnull PolarisCallContext callCtx, PolarisEntityCore securable) {
        throw this.illegalMethodError("loadGrantsOnSecurable");
    }

    @Override
    @Nonnull
    public LoadGrantsResult loadGrantsToGrantee(@Nonnull PolarisCallContext callCtx, PolarisEntityCore grantee) {
        throw this.illegalMethodError("loadGrantsToGrantee");
    }

    @Override
    @Nonnull
    public ChangeTrackingResult loadEntitiesChangeTracking(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityId> entityIds) {
        throw this.illegalMethodError("loadEntitiesChangeTracking");
    }

    @Override
    @Nonnull
    public EntityResult loadEntity(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long entityId, @Nonnull PolarisEntityType entityType) {
        throw this.illegalMethodError("loadEntity");
    }

    @Override
    @Nonnull
    public EntitiesResult loadTasks(@Nonnull PolarisCallContext callCtx, String executorId, PageToken pageToken) {
        throw this.illegalMethodError("loadTasks");
    }

    @Override
    @Nonnull
    public ScopedCredentialsResult getSubscopedCredsForEntity(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, @Nonnull PolarisEntityType entityType, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        return this.delegate.getSubscopedCredsForEntity(callCtx, catalogId, entityId, entityType, allowListOperation, allowedReadLocations, allowedWriteLocations, refreshCredentialsEndpoint);
    }

    @Override
    @Nonnull
    public ResolvedEntityResult loadResolvedEntityById(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long entityId, PolarisEntityType entityType) {
        throw this.illegalMethodError("loadResolvedEntityById");
    }

    @Override
    @Nonnull
    public ResolvedEntityResult loadResolvedEntityByName(@Nonnull PolarisCallContext callCtx, long entityCatalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull String entityName) {
        throw this.illegalMethodError("loadResolvedEntityByName");
    }

    @Override
    @Nonnull
    public ResolvedEntitiesResult loadResolvedEntities(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityType entityType, @Nonnull List<PolarisEntityId> entityIds) {
        throw this.illegalMethodError("loadResolvedEntities");
    }

    @Override
    @Nonnull
    public ResolvedEntityResult refreshResolvedEntity(@Nonnull PolarisCallContext callCtx, int entityVersion, int entityGrantRecordsVersion, @Nonnull PolarisEntityType entityType, long entityCatalogId, long entityId) {
        throw this.illegalMethodError("refreshResolvedEntity");
    }

    @Override
    public <T extends PolarisEntity> Optional<Optional<String>> hasOverlappingSiblings(@Nonnull PolarisCallContext callContext, T entity) {
        throw this.illegalMethodError("hasOverlappingSiblings");
    }

    @Override
    @Nonnull
    public PolicyAttachmentResult attachPolicyToEntity(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityCore> targetCatalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy, Map<String, String> parameters) {
        throw this.illegalMethodError("attachPolicyToEntity");
    }

    @Override
    @Nonnull
    public PolicyAttachmentResult detachPolicyFromEntity(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEntityCore> catalogPath, @Nonnull PolarisEntityCore target, @Nonnull List<PolarisEntityCore> policyCatalogPath, @Nonnull PolicyEntity policy) {
        throw this.illegalMethodError("detachPolicyFromEntity");
    }

    @Override
    @Nonnull
    public LoadPolicyMappingsResult loadPoliciesOnEntity(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore target) {
        throw this.illegalMethodError("loadPoliciesOnEntity");
    }

    @Override
    @Nonnull
    public LoadPolicyMappingsResult loadPoliciesOnEntityByType(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore target, @Nonnull PolicyType policyType) {
        throw this.illegalMethodError("loadPoliciesOnEntityByType");
    }

    @Override
    public void writeEvents(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisEvent> polarisEvents) {
        throw this.illegalMethodError("writeEvents");
    }
}

