/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.message;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.replicator.message.ReplicaResponse;
import org.apache.ignite3.internal.replicator.message.ReplicaResponseBuilder;

class ReplicaResponseDeserializer
implements MessageDeserializer<ReplicaResponse> {
    private final ReplicaResponseBuilder msg;

    ReplicaResponseDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.replicaResponse();
    }

    @Override
    public Class<ReplicaResponse> klass() {
        return ReplicaResponse.class;
    }

    @Override
    public ReplicaResponse getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("resultByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.resultByteArray(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReplicaResponse.class);
    }
}

