/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.systemviews;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogSystemViewProvider;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.systemview.api.ClusterSystemView;
import org.apache.ignite3.internal.systemview.api.SystemView;
import org.apache.ignite3.internal.systemview.api.SystemViews;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.util.SubscriptionUtils;
import org.jetbrains.annotations.Nullable;

public class IndexColumnsSystemViewProvider
implements CatalogSystemViewProvider {
    @Override
    public List<SystemView<?>> getView(Supplier<Catalog> catalogSupplier) {
        Iterable indexColumns = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.schemas().stream().flatMap(schema -> Arrays.stream(schema.indexes()).flatMap(index -> {
                CatalogTableDescriptor table = catalog.table(index.tableId());
                if (table == null) {
                    return Stream.empty();
                }
                return Stream.of(new IndexColumnContainer((CatalogSchemaDescriptor)schema, table, (CatalogIndexDescriptor)index));
            })).flatMap(container -> {
                switch (container.index.indexType()) {
                    case HASH: {
                        return IndexColumnsSystemViewProvider.createHashIndexColumns(container, (CatalogHashIndexDescriptor)container.index);
                    }
                    case SORTED: {
                        return IndexColumnsSystemViewProvider.createSortedIndexColumns(container, (CatalogSortedIndexDescriptor)container.index);
                    }
                }
                return Stream.empty();
            }).iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(indexColumns);
        SystemView systemView = ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("INDEX_COLUMNS")).addColumn("SCHEMA_ID", NativeTypes.INT32, col -> col.container.schemaId)).addColumn("SCHEMA_NAME", NativeTypes.STRING, col -> col.container.schemaName)).addColumn("TABLE_ID", NativeTypes.INT32, col -> col.container.tableId)).addColumn("TABLE_NAME", NativeTypes.STRING, col -> col.container.tableName)).addColumn("INDEX_ID", NativeTypes.INT32, col -> col.container.indexId)).addColumn("INDEX_NAME", NativeTypes.STRING, col -> col.container.indexName)).addColumn("COLUMN_NAME", NativeTypes.STRING, col -> col.columnName)).addColumn("COLUMN_ORDINAL", NativeTypes.INT32, col -> col.columnOrdinal)).addColumn("COLUMN_COLLATION", NativeTypes.STRING, col -> col.columnCollation)).dataProvider(viewDataPublisher)).build();
        return List.of(systemView);
    }

    private static Stream<IndexColumn> createSortedIndexColumns(IndexColumnContainer container, CatalogSortedIndexDescriptor index) {
        ArrayList<IndexColumn> columns = new ArrayList<IndexColumn>();
        for (CatalogIndexColumnDescriptor column : index.columns()) {
            columns.add(new IndexColumn(container, column.name(), columns.size(), column.collation()));
        }
        return columns.stream();
    }

    private static Stream<IndexColumn> createHashIndexColumns(IndexColumnContainer container, CatalogHashIndexDescriptor index) {
        ArrayList<IndexColumn> columns = new ArrayList<IndexColumn>();
        for (String column : index.columns()) {
            columns.add(new IndexColumn(container, column, columns.size()));
        }
        return columns.stream();
    }

    private static class IndexColumn {
        private final IndexColumnContainer container;
        private final String columnName;
        private final int columnOrdinal;
        @Nullable
        private final String columnCollation;

        IndexColumn(IndexColumnContainer container, String name, int ordinal) {
            this.container = container;
            this.columnName = name;
            this.columnOrdinal = ordinal;
            this.columnCollation = null;
        }

        IndexColumn(IndexColumnContainer container, String name, int ordinal, CatalogColumnCollation collation) {
            this.container = container;
            this.columnName = name;
            this.columnOrdinal = ordinal;
            this.columnCollation = collation.name();
        }
    }

    private static class IndexColumnContainer {
        private final int schemaId;
        private final String schemaName;
        private final int tableId;
        private final String tableName;
        private final int indexId;
        private final String indexName;
        private final CatalogIndexDescriptor index;

        IndexColumnContainer(CatalogSchemaDescriptor schema, CatalogTableDescriptor table, CatalogIndexDescriptor index) {
            this.schemaId = schema.id();
            this.schemaName = schema.name();
            this.tableId = table.id();
            this.tableName = table.name();
            this.indexId = index.id();
            this.indexName = index.name();
            this.index = index;
        }
    }
}

