/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.table.RecordBinaryViewImpl;
import org.apache.ignite3.table.IgniteTables;
import org.apache.ignite3.table.Tuple;

public class ClientStreamerBatchSendRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteTables tables) {
        int tableId = in.unpackInt();
        int partition = in.unpackInt();
        BitSet deleted = in.unpackBitSetNullable();
        int schemaId = in.unpackInt();
        int count = in.unpackInt();
        BitSet[] noValueSet = new BitSet[count];
        byte[][] tupleBytes = new byte[count][];
        for (int i = 0; i < count; ++i) {
            noValueSet[i] = in.unpackBitSet();
            tupleBytes[i] = in.readBinary();
        }
        return ClientTableCommon.readTableAsync(tableId, tables).thenCompose(table -> ClientTableCommon.readSchema(schemaId, table).thenCompose(schema -> {
            ArrayList<Tuple> tuples = new ArrayList<Tuple>(count);
            for (int i = 0; i < count; ++i) {
                boolean keyOnly = deleted != null && deleted.get(i);
                tuples.add(ClientTableCommon.readTuple(noValueSet[i], tupleBytes[i], keyOnly, schema));
            }
            RecordBinaryViewImpl recordView = (RecordBinaryViewImpl)table.recordView();
            return recordView.updateAll(partition, tuples, deleted).thenApply(unused -> out -> out.packInt(table.schemaView().lastKnownSchemaVersion()));
        }));
    }
}

