/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.failure.handlers.configuration;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.failure.handlers.configuration.IgnoredFailureTypes;

public class IgnoredFailureTypesValidator
implements Validator<IgnoredFailureTypes, String[]> {
    public static final IgnoredFailureTypesValidator INSTANCE = new IgnoredFailureTypesValidator();

    public void validate(IgnoredFailureTypes annotation, ValidationContext<String[]> ctx) {
        String[] ignoredFailureTypes;
        Set possibleFailureTypes = Arrays.stream(FailureType.values()).map(FailureType::typeName).collect(Collectors.toSet());
        for (String ignoredFailureType : ignoredFailureTypes = (String[])ctx.getNewValue()) {
            if (possibleFailureTypes.contains(ignoredFailureType)) continue;
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), String.format("Unknown failure type '%s'. The possible values are %s.", ignoredFailureType, possibleFailureTypes)));
        }
    }
}

