/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.configuration.ConfigurationWrongPolymorphicTypeIdException;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.internal.configuration.ConfigurationNode;
import org.apache.ignite.internal.configuration.ConfigurationTreeWrapper;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.DynamicProperty;
import org.apache.ignite.internal.configuration.NamedListConfiguration;
import org.apache.ignite.internal.configuration.asm.AbstractAsmGenerator;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.asm.DirectProxyAsmGenerator;
import org.apache.ignite.internal.configuration.asm.SchemaClassesInfo;
import org.apache.ignite.internal.configuration.asm.StringSwitchBuilder;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

class ConfigurationImplAsmGenerator
extends AbstractAsmGenerator {
    private static final Constructor<?> DYNAMIC_CONFIGURATION_CTOR;
    private static final Method DYNAMIC_CONFIGURATION_ADD_MTD;
    private static final Method REFRESH_VALUE_MTD;
    private static final Method ADD_MEMBER_MTD;
    private static final Method REMOVE_MEMBER_MTD;
    private static final Method SPECIFIC_CONFIG_TREE_MTD;
    private static final String EXTENSION_CONFIG_TYPES_FIELD_NAME = "_extensionConfigTypes";
    private ClassDefinition cfgImplClassDef;

    ConfigurationImplAsmGenerator(ConfigurationAsmGenerator cgen, Class<?> schemaClass, Set<Class<?>> extensions, Set<Class<?>> polymorphicExtensions, List<Field> schemaFields, Collection<Field> publicExtensionFields, Collection<Field> internalExtensionFields, Collection<Field> polymorphicFields, @Nullable Field internalIdField) {
        super(cgen, schemaClass, extensions, polymorphicExtensions, schemaFields, publicExtensionFields, internalExtensionFields, polymorphicFields, internalIdField);
    }

    @Override
    public List<ClassDefinition> generate() {
        assert (this.cfgImplClassDef == null);
        ArrayList<ClassDefinition> classDefs = new ArrayList<ClassDefinition>();
        classDefs.add(this.createCfgImplClass());
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            Collection polymorphicFields = this.polymorphicFields.stream().filter(f -> f.getDeclaringClass() == polymorphicExtension).collect(Collectors.toList());
            classDefs.add(this.createPolymorphicExtensionCfgImplClass(polymorphicExtension, polymorphicFields));
        }
        return classDefs;
    }

    private ClassDefinition createCfgImplClass() {
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        this.cfgImplClassDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(schemaClassInfo.cfgImplClassName), ParameterizedType.type(DynamicConfiguration.class), this.cgen.configClassInterfaces(this.schemaClass, this.extensions));
        HashMap<String, FieldDefinition> fieldDefs = new HashMap<String, FieldDefinition>();
        FieldDefinition polymorphicTypeIdFieldDef = null;
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields, this.polymorphicFields})) {
            String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
            FieldDefinition fieldDef = this.addConfigurationImplField(schemaField, fieldName);
            fieldDefs.put(fieldName, fieldDef);
            if (!ConfigurationUtil.isPolymorphicId(schemaField)) continue;
            polymorphicTypeIdFieldDef = fieldDef;
        }
        if (this.internalIdField != null) {
            String fieldName = this.internalIdField.getName();
            FieldDefinition fieldDef = this.addConfigurationImplField(this.internalIdField, fieldName);
            fieldDefs.put(fieldName, fieldDef);
        }
        FieldDefinition extensionConfigTypesFieldDef = null;
        if (!this.extensions.isEmpty()) {
            extensionConfigTypesFieldDef = this.cfgImplClassDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), EXTENSION_CONFIG_TYPES_FIELD_NAME, Class[].class);
        }
        this.addConfigurationImplConstructor(fieldDefs, extensionConfigTypesFieldDef);
        this.addDirectProxyMethod(schemaClassInfo);
        if (this.internalIdField != null) {
            this.addConfigurationImplGetMethod(this.cfgImplClassDef, this.internalIdField, (FieldDefinition)fieldDefs.get(this.internalIdField.getName()));
        }
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
            this.addConfigurationImplGetMethod(this.cfgImplClassDef, schemaField, (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField)));
        }
        this.addCfgImplConfigTypeMethod(ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgClassName));
        if (extensionConfigTypesFieldDef != null) {
            ConfigurationImplAsmGenerator.addCfgImplInternalConfigTypesMethod(this.cfgImplClassDef, extensionConfigTypesFieldDef);
        }
        if (!this.polymorphicExtensions.isEmpty()) {
            this.addCfgSpecificConfigTreeMethod(polymorphicTypeIdFieldDef);
            this.addCfgRemoveMembersMethod(fieldDefs, polymorphicTypeIdFieldDef);
            this.addCfgAddMembersMethod(fieldDefs, polymorphicTypeIdFieldDef);
            this.addCfgImplPolymorphicInstanceConfigTypeMethod(polymorphicTypeIdFieldDef);
        }
        return this.cfgImplClassDef;
    }

    private FieldDefinition addConfigurationImplField(Field schemaField, String fieldName) {
        ParameterizedType fieldType = ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName((String)this.cgen.schemaInfo(schemaField.getType()).cfgImplClassName) : (ConfigurationUtil.isNamedConfigValue(schemaField) ? ParameterizedType.type(NamedListConfiguration.class) : ParameterizedType.type(DynamicProperty.class));
        return this.cfgImplClassDef.declareField(EnumSet.of(Access.PUBLIC), fieldName, fieldType);
    }

    private void addConfigurationImplConstructor(Map<String, FieldDefinition> fieldDefs, @Nullable FieldDefinition extensionConfigTypesFieldDef) {
        MethodDefinition ctor = this.cfgImplClassDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[]{Parameter.arg((String)"prefix", List.class), Parameter.arg((String)"key", String.class), Parameter.arg((String)"rootKey", RootKey.class), Parameter.arg((String)"changer", DynamicConfigurationChanger.class), Parameter.arg((String)"listenOnly", Boolean.TYPE)});
        Variable rootKeyVar = ctor.getScope().getVariable("rootKey");
        Variable changerVar = ctor.getScope().getVariable("changer");
        Variable listenOnlyVar = ctor.getScope().getVariable("listenOnly");
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        Variable thisVar = ctor.getThis();
        BytecodeBlock ctorBody = ctor.getBody().append((BytecodeNode)thisVar).append((BytecodeNode)ctor.getScope().getVariable("prefix")).append((BytecodeNode)ctor.getScope().getVariable("key")).append((BytecodeNode)rootKeyVar).append((BytecodeNode)changerVar).append((BytecodeNode)listenOnlyVar).invokeConstructor(DYNAMIC_CONFIGURATION_CTOR);
        BytecodeExpression thisKeysVar = thisVar.getField("keys", List.class);
        List internalIdFieldAsList = this.internalIdField == null ? Collections.emptyList() : List.of(this.internalIdField);
        int newIdx = 0;
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields, this.polymorphicFields, internalIdFieldAsList})) {
            BytecodeExpression newValue;
            String publicName = ConfigurationAsmGenerator.publicName(schemaField);
            if (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField)) {
                newValue = BytecodeExpressions.newInstance(DynamicProperty.class, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)(ConfigurationUtil.isInjectedName(schemaField) ? "<injected_name>" : (ConfigurationUtil.isInternalId(schemaField) ? "<internal_id>" : publicName))), rootKeyVar, changerVar, listenOnlyVar, BytecodeExpressions.constantBoolean((boolean)ConfigurationUtil.isReadOnly(schemaField))});
            } else {
                SchemaClassesInfo fieldInfo = this.cgen.schemaInfo(schemaField.getType());
                ParameterizedType cfgImplParameterizedType = ParameterizedType.typeFromJavaClassName((String)fieldInfo.cfgImplClassName);
                if (ConfigurationUtil.isConfigValue(schemaField)) {
                    newValue = BytecodeExpressions.newInstance((ParameterizedType)cfgImplParameterizedType, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)publicName), rootKeyVar, changerVar, listenOnlyVar});
                } else {
                    MethodDefinition newMtd = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PRIVATE, Access.STATIC, Access.SYNTHETIC), "$new$" + newIdx++, ParameterizedType.typeFromJavaClassName((String)fieldInfo.cfgClassName), new Parameter[]{Parameter.arg((String)"rootKey", RootKey.class), Parameter.arg((String)"changer", DynamicConfigurationChanger.class), Parameter.arg((String)"listenOnly", Boolean.TYPE), Parameter.arg((String)"prefix", List.class), Parameter.arg((String)"key", String.class)});
                    newValue = BytecodeExpressions.newInstance(NamedListConfiguration.class, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)publicName), rootKeyVar, changerVar, listenOnlyVar, BytecodeExpressions.invokeDynamic((Method)LAMBDA_METAFACTORY, Arrays.asList(Type.getMethodType((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), new Handle(6, ConfigurationAsmGenerator.internalName(schemaClassInfo.cfgImplClassName), newMtd.getName(), newMtd.getMethodDescriptor(), false), Type.getMethodType((Type)ParameterizedType.typeFromJavaClassName((String)fieldInfo.cfgClassName).getAsmType(), (Type[])new Type[]{Type.getType(List.class), Type.getType(String.class)})), (String)"apply", BiFunction.class, (BytecodeExpression[])new BytecodeExpression[]{rootKeyVar, changerVar, listenOnlyVar}), DirectProxyAsmGenerator.newDirectProxyLambda(fieldInfo), BytecodeExpressions.newInstance((ParameterizedType)cfgImplParameterizedType, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)"any"), rootKeyVar, changerVar, BytecodeExpressions.constantBoolean((boolean)true)}).cast(ConfigurationProperty.class)});
                    newMtd.getBody().append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)cfgImplParameterizedType, (BytecodeExpression[])new BytecodeExpression[]{newMtd.getScope().getVariable("prefix"), newMtd.getScope().getVariable("key"), newMtd.getScope().getVariable("rootKey"), newMtd.getScope().getVariable("changer"), newMtd.getScope().getVariable("listenOnly")})).retObject();
                }
            }
            FieldDefinition fieldDef = fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField));
            ctorBody.append((BytecodeNode)thisVar.setField(fieldDef, newValue));
            if (ConfigurationUtil.isPolymorphicConfigInstance(schemaField.getDeclaringClass()) || ConfigurationUtil.isInternalId(schemaField)) continue;
            ctorBody.append((BytecodeNode)thisVar.invoke(DYNAMIC_CONFIGURATION_ADD_MTD, new BytecodeExpression[]{thisVar.getField(fieldDef)}));
        }
        if (extensionConfigTypesFieldDef != null) {
            assert (!this.extensions.isEmpty()) : this.cfgImplClassDef;
            Variable tmpVar = ctor.getScope().createTempVariable(Class[].class);
            BytecodeBlock initExtensionConfigTypesField = new BytecodeBlock();
            initExtensionConfigTypesField.append((BytecodeNode)tmpVar.set(BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Class[].class), (int)this.extensions.size())));
            int i = 0;
            for (Class extension : this.extensions) {
                initExtensionConfigTypesField.append((BytecodeNode)BytecodeExpressions.set((BytecodeExpression)tmpVar, (BytecodeExpression)BytecodeExpressions.constantInt((int)i++), (BytecodeExpression)BytecodeExpressions.constantClass((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.configurationClassName(extension)))));
            }
            initExtensionConfigTypesField.append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(ctor, (BytecodeExpression)tmpVar, extensionConfigTypesFieldDef));
            ctorBody.append((BytecodeNode)initExtensionConfigTypesField);
        }
        ctorBody.ret();
    }

    private void addDirectProxyMethod(SchemaClassesInfo schemaClassInfo) {
        MethodDefinition methodDef = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "directProxy", ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgClassName), new Parameter[0]);
        methodDef.getBody().append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.directProxyClassName), (BytecodeExpression[])new BytecodeExpression[]{methodDef.getThis().invoke("keyPath", List.class, new BytecodeExpression[0]), methodDef.getThis().getField("changer", DynamicConfigurationChanger.class)}));
        methodDef.getBody().retObject();
    }

    private void addConfigurationImplGetMethod(ClassDefinition classDef, Field schemaField, FieldDefinition ... fieldDefs) {
        ParameterizedType returnType;
        assert (!ArrayUtils.nullOrEmpty((Object[])fieldDefs));
        Class<?> schemaFieldType = schemaField.getType();
        String fieldName = schemaField.getName();
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(schemaFieldType);
        if (ConfigurationUtil.isConfigValue(schemaField)) {
            returnType = ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgClassName);
        } else if (ConfigurationUtil.isNamedConfigValue(schemaField)) {
            returnType = ParameterizedType.type(NamedConfigurationTree.class);
        } else {
            assert (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField)) : schemaField;
            returnType = ParameterizedType.type(ConfigurationValue.class);
        }
        MethodDefinition viewMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), fieldName, returnType, new Parameter[0]);
        BytecodeBlock body = viewMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(viewMtd, fieldDefs));
        if (ConfigurationUtil.isPolymorphicConfig(schemaFieldType) && ConfigurationUtil.isConfigValue(schemaField)) {
            body.invokeVirtual(SPECIFIC_CONFIG_TREE_MTD);
        }
        body.retObject();
    }

    private void addCfgImplConfigTypeMethod(ParameterizedType clazz) {
        this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "configType", ParameterizedType.type(Class.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantClass((ParameterizedType)clazz)).retObject();
    }

    private static void addCfgImplInternalConfigTypesMethod(ClassDefinition classDef, FieldDefinition extensionConfigTypesDef) {
        MethodDefinition extensionConfigTypesMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "extensionConfigTypes", ParameterizedType.type(Class[].class), new Parameter[0]);
        extensionConfigTypesMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(extensionConfigTypesMtd, extensionConfigTypesDef)).retObject();
    }

    private void addCfgImplPolymorphicInstanceConfigTypeMethod(FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition polymorphicInstanceConfigTypeMtd = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "polymorphicInstanceConfigType", ParameterizedType.type(Class.class), new Parameter[0]);
        Variable tmpStrVar = polymorphicInstanceConfigTypeMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(polymorphicInstanceConfigTypeMtd.getScope()).expression((BytecodeExpression)tmpStrVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{tmpStrVar}));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)BytecodeExpressions.constantClass((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.configurationClassName(polymorphicExtension))).ret());
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.nodeClassName(this.schemaClass));
        Variable tmpObjVar = polymorphicInstanceConfigTypeMtd.getScope().createTempVariable(Object.class);
        Variable thisVar = polymorphicInstanceConfigTypeMtd.getThis();
        polymorphicInstanceConfigTypeMtd.getBody().append((BytecodeNode)tmpObjVar.set(thisVar.invoke(REFRESH_VALUE_MTD, new BytecodeExpression[0]))).append((BytecodeNode)tmpStrVar.set(tmpObjVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append((BytecodeNode)switchBuilder.build()).ret();
    }

    private ClassDefinition createPolymorphicExtensionCfgImplClass(Class<?> polymorphicExtension, Collection<Field> polymorphicFields) {
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        SchemaClassesInfo polymorphicExtensionClassInfo = this.cgen.schemaInfo(polymorphicExtension);
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(polymorphicExtensionClassInfo.cfgImplClassName), ParameterizedType.type(ConfigurationTreeWrapper.class), this.cgen.configClassInterfaces(polymorphicExtension, Set.of()));
        FieldDefinition parentCfgImplFieldDef = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "this$0", ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgImplClassName));
        MethodDefinition constructorMtd = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[]{Parameter.arg((String)"delegate", (ParameterizedType)ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgImplClassName))});
        Variable delegateVar = constructorMtd.getScope().getVariable("delegate");
        constructorMtd.getBody().append((BytecodeNode)constructorMtd.getThis()).append((BytecodeNode)delegateVar).invokeConstructor(ConfigurationTreeWrapper.class, new Class[]{ConfigurationTree.class}).append((BytecodeNode)constructorMtd.getThis().setField(parentCfgImplFieldDef, (BytecodeExpression)delegateVar)).ret();
        Map fieldDefs = this.cfgImplClassDef.getFields().stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
        if (this.internalIdField != null) {
            this.addConfigurationImplGetMethod(classDef, this.internalIdField, parentCfgImplFieldDef, (FieldDefinition)fieldDefs.get(this.internalIdField.getName()));
        }
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{this.schemaFields, polymorphicFields})) {
            this.addConfigurationImplGetMethod(classDef, schemaField, parentCfgImplFieldDef, (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField)));
        }
        return classDef;
    }

    private void addCfgSpecificConfigTreeMethod(FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition specificConfigMtd = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), SPECIFIC_CONFIG_TREE_MTD.getName(), ParameterizedType.type(ConfigurationTree.class), new Parameter[0]);
        Variable tmpStrVar = specificConfigMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(specificConfigMtd.getScope()).expression((BytecodeExpression)tmpStrVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{tmpStrVar}));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)this.cgen.schemaInfo(polymorphicExtension).cfgImplClassName), (BytecodeExpression[])new BytecodeExpression[]{specificConfigMtd.getThis()}).ret());
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName((String)this.cgen.schemaInfo(this.schemaClass).nodeClassName);
        Variable tmpObjVar = specificConfigMtd.getScope().createTempVariable(Object.class);
        specificConfigMtd.getBody().append((BytecodeNode)tmpObjVar.set(specificConfigMtd.getThis().invoke(REFRESH_VALUE_MTD, new BytecodeExpression[0]))).append((BytecodeNode)tmpStrVar.set(tmpObjVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append((BytecodeNode)switchBuilder.build()).ret();
    }

    private void addCfgRemoveMembersMethod(Map<String, FieldDefinition> fieldDefs, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition removeMembersMtd = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "removeMembers", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"oldValue", (ParameterizedType)ParameterizedType.type(Object.class)), Parameter.arg((String)"members", (ParameterizedType)ParameterizedType.type(Map.class))});
        Variable oldValueVar = removeMembersMtd.getScope().getVariable("oldValue");
        Variable membersVar = removeMembersMtd.getScope().getVariable("members");
        Variable tmpStrVar = removeMembersMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(removeMembersMtd.getScope()).expression((BytecodeExpression)tmpStrVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{tmpStrVar}));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            Collection removeFields = this.polymorphicFields.stream().filter(f -> !polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList());
            BytecodeBlock blockCode = new BytecodeBlock();
            for (Field removeField : removeFields) {
                blockCode.append((BytecodeNode)removeMembersMtd.getThis()).append((BytecodeNode)membersVar).append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(removeMembersMtd, fieldDefs.get(ConfigurationAsmGenerator.fieldName(removeField)))).invokeVirtual(REMOVE_MEMBER_MTD);
            }
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)blockCode);
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName((String)this.cgen.schemaInfo(this.schemaClass).nodeClassName);
        removeMembersMtd.getBody().append((BytecodeNode)tmpStrVar.set(oldValueVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append((BytecodeNode)switchBuilder.build()).ret();
    }

    private void addCfgAddMembersMethod(Map<String, FieldDefinition> fieldDefs, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition removeMembersMtd = this.cfgImplClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "addMembers", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"newValue", (ParameterizedType)ParameterizedType.type(Object.class)), Parameter.arg((String)"members", (ParameterizedType)ParameterizedType.type(Map.class))});
        Variable newValueVar = removeMembersMtd.getScope().getVariable("newValue");
        Variable membersVar = removeMembersMtd.getScope().getVariable("members");
        Variable tmpStrVar = removeMembersMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(removeMembersMtd.getScope()).expression((BytecodeExpression)tmpStrVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{tmpStrVar}));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            Collection addFields = this.polymorphicFields.stream().filter(f -> polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList());
            BytecodeBlock blockCode = new BytecodeBlock();
            for (Field addField : addFields) {
                blockCode.append((BytecodeNode)removeMembersMtd.getThis()).append((BytecodeNode)membersVar).append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(removeMembersMtd, fieldDefs.get(ConfigurationAsmGenerator.fieldName(addField)))).invokeVirtual(ADD_MEMBER_MTD);
            }
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)blockCode);
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName((String)this.cgen.schemaInfo(this.schemaClass).nodeClassName);
        removeMembersMtd.getBody().append((BytecodeNode)tmpStrVar.set(newValueVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append((BytecodeNode)switchBuilder.build()).ret();
    }

    static {
        try {
            DYNAMIC_CONFIGURATION_CTOR = DynamicConfiguration.class.getDeclaredConstructor(List.class, String.class, RootKey.class, DynamicConfigurationChanger.class, Boolean.TYPE);
            DYNAMIC_CONFIGURATION_ADD_MTD = DynamicConfiguration.class.getDeclaredMethod("add", ConfigurationProperty.class);
            REFRESH_VALUE_MTD = ConfigurationNode.class.getDeclaredMethod("refreshValue", new Class[0]);
            ADD_MEMBER_MTD = DynamicConfiguration.class.getDeclaredMethod("addMember", Map.class, ConfigurationProperty.class);
            REMOVE_MEMBER_MTD = DynamicConfiguration.class.getDeclaredMethod("removeMember", Map.class, ConfigurationProperty.class);
            SPECIFIC_CONFIG_TREE_MTD = DynamicConfiguration.class.getDeclaredMethod("specificConfigTree", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
    }
}

