/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.FieldDescriptor;
import org.jetbrains.annotations.Nullable;

public class MergedField {
    private final FieldDescriptor localField;
    private final FieldDescriptor remoteField;

    public static MergedField localOnly(FieldDescriptor localField) {
        return new MergedField(localField, null);
    }

    public static MergedField remoteOnly(FieldDescriptor remoteField) {
        return new MergedField(null, remoteField);
    }

    public MergedField(@Nullable FieldDescriptor localField, @Nullable FieldDescriptor remoteField) {
        assert (localField != null || remoteField != null) : "Both descriptors are null";
        assert (localField == null || remoteField == null || localField.name().equals(remoteField.name())) : "Field descriptors with different names: " + localField.name() + " and " + remoteField.name();
        this.localField = localField;
        this.remoteField = remoteField;
    }

    public boolean hasRemote() {
        return this.remoteField != null;
    }

    public FieldDescriptor remote() {
        return Objects.requireNonNull(this.remoteField, "remoteField is null");
    }

    public boolean hasLocal() {
        return this.localField != null;
    }

    public FieldDescriptor local() {
        return Objects.requireNonNull(this.localField, "localField is null");
    }

    public String name() {
        return this.localField != null ? this.localField.name() : this.remoteField.name();
    }

    public boolean typesAreDifferent() {
        return this.local().localClass() != this.remote().localClass();
    }

    public boolean typesAreCompatible() {
        return this.local().localClass().isAssignableFrom(this.remote().localClass());
    }

    public Object convertToLocalType(Object fieldValue) {
        return this.local().localClass().cast(fieldValue);
    }
}

