/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.explain;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexVisitor;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.explain.RelTreeToTextWriter;
import org.jetbrains.annotations.Nullable;

public final class ExplainUtils {
    private ExplainUtils() {
        throw new AssertionError((Object)"Should not be called");
    }

    public static String toString(IgniteRel rel) {
        return RelTreeToTextWriter.dumpTree(rel, 0);
    }

    public static String toString(IgniteRel rel, int padding) {
        return RelTreeToTextWriter.dumpTree(rel, (padding + 1) / 2);
    }

    static RexShuttle inputRefRewriter(final RelDataType rowType) {
        return new RexShuttle(){

            public RexNode visitLocalRef(RexLocalRef ref) {
                return new NamedRexSlot((String)rowType.getFieldNames().get(ref.getIndex()), ref.getIndex(), ref.getType());
            }

            public RexNode visitInputRef(RexInputRef ref) {
                return new NamedRexSlot((String)rowType.getFieldNames().get(ref.getIndex()), ref.getIndex(), ref.getType());
            }
        };
    }

    private static class NamedRexSlot
    extends RexSlot {
        NamedRexSlot(String name, int index, RelDataType type) {
            super(name, index, type);
        }

        public <R> R accept(RexVisitor<R> visitor) {
            throw new AssertionError((Object)"Should not be called");
        }

        public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
            throw new AssertionError((Object)"Should not be called");
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof NamedRexSlot && this.index == ((NamedRexSlot)((Object)obj)).index;
        }

        public int hashCode() {
            return this.index;
        }
    }
}

