/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.thetacommon.HashOperations;
import org.apache.datasketches.thetacommon.SetOperationCornerCases;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.QuickSelectSketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.Util;

public final class TupleAnotB<S extends Summary> {
    private boolean empty_ = true;
    private long thetaLong_ = Long.MAX_VALUE;
    private long[] hashArr_ = null;
    private S[] summaryArr_ = null;
    private int curCount_ = 0;
    private static final Method GET_CACHE;

    public void setA(TupleSketch<S> skA) {
        if (skA == null) {
            this.reset();
            throw new SketchesArgumentException("The input argument <i>A</i> may not be null");
        }
        this.empty_ = skA.isEmpty();
        this.thetaLong_ = skA.getThetaLong();
        DataArrays<S> da = TupleAnotB.getCopyOfDataArraysTuple(skA);
        this.summaryArr_ = da.summaryArr;
        this.hashArr_ = da.hashArr;
        this.curCount_ = this.hashArr_ == null ? 0 : this.hashArr_.length;
    }

    public void notB(TupleSketch<S> skB) {
        if (skB == null) {
            return;
        }
        long thetaLongB = skB.getThetaLong();
        int countB = skB.getRetainedEntries();
        boolean emptyB = skB.isEmpty();
        int id = SetOperationCornerCases.createCornerCaseId(this.thetaLong_, this.curCount_, this.empty_, thetaLongB, countB, emptyB);
        SetOperationCornerCases.CornerCase cCase = SetOperationCornerCases.CornerCase.caseIdToCornerCase(id);
        SetOperationCornerCases.AnotbAction anotbAction = cCase.getAnotbAction();
        switch (anotbAction) {
            case EMPTY_1_0_T: {
                this.reset();
                break;
            }
            case DEGEN_MIN_0_F: {
                this.reset();
                this.thetaLong_ = Math.min(this.thetaLong_, thetaLongB);
                this.empty_ = false;
                break;
            }
            case DEGEN_THA_0_F: {
                this.empty_ = false;
                this.curCount_ = 0;
                break;
            }
            case TRIM_A: {
                this.thetaLong_ = Math.min(this.thetaLong_, thetaLongB);
                DataArrays da = TupleAnotB.trimAndCopyDataArrays((long[])this.hashArr_, this.summaryArr_, (long)this.thetaLong_, (boolean)true);
                this.hashArr_ = da.hashArr;
                this.curCount_ = this.hashArr_ == null ? 0 : this.hashArr_.length;
                this.summaryArr_ = da.summaryArr;
                break;
            }
            case SKETCH_A: {
                break;
            }
            case FULL_ANOTB: {
                this.thetaLong_ = Math.min(this.thetaLong_, thetaLongB);
                DataArrays daR = TupleAnotB.getCopyOfResultArraysTuple((long)this.thetaLong_, (int)this.curCount_, (long[])this.hashArr_, this.summaryArr_, skB);
                this.hashArr_ = daR.hashArr;
                this.curCount_ = this.hashArr_ == null ? 0 : this.hashArr_.length;
                this.summaryArr_ = daR.summaryArr;
            }
        }
    }

    public void notB(ThetaSketch skB) {
        if (skB == null) {
            return;
        }
        long thetaLongB = skB.getThetaLong();
        int countB = skB.getRetainedEntries();
        boolean emptyB = skB.isEmpty();
        int id = SetOperationCornerCases.createCornerCaseId(this.thetaLong_, this.curCount_, this.empty_, thetaLongB, countB, emptyB);
        SetOperationCornerCases.CornerCase cCase = SetOperationCornerCases.CornerCase.caseIdToCornerCase(id);
        SetOperationCornerCases.AnotbAction anotbAction = cCase.getAnotbAction();
        switch (anotbAction) {
            case EMPTY_1_0_T: {
                this.reset();
                break;
            }
            case DEGEN_MIN_0_F: {
                this.reset();
                this.thetaLong_ = Math.min(this.thetaLong_, thetaLongB);
                this.empty_ = false;
                break;
            }
            case DEGEN_THA_0_F: {
                this.empty_ = false;
                this.curCount_ = 0;
                break;
            }
            case TRIM_A: {
                this.thetaLong_ = Math.min(this.thetaLong_, thetaLongB);
                DataArrays da = TupleAnotB.trimAndCopyDataArrays((long[])this.hashArr_, this.summaryArr_, (long)this.thetaLong_, (boolean)true);
                this.hashArr_ = da.hashArr;
                this.curCount_ = this.hashArr_ == null ? 0 : this.hashArr_.length;
                this.summaryArr_ = da.summaryArr;
                break;
            }
            case SKETCH_A: {
                break;
            }
            case FULL_ANOTB: {
                this.thetaLong_ = Math.min(this.thetaLong_, thetaLongB);
                DataArrays daB = TupleAnotB.getCopyOfResultArraysTheta((long)this.thetaLong_, (int)this.curCount_, (long[])this.hashArr_, this.summaryArr_, (ThetaSketch)skB);
                this.hashArr_ = daB.hashArr;
                this.curCount_ = this.hashArr_ == null ? 0 : this.hashArr_.length;
                this.summaryArr_ = daB.summaryArr;
            }
        }
    }

    public CompactTupleSketch<S> getResult(boolean reset) {
        CompactTupleSketch result = this.curCount_ == 0 ? new CompactTupleSketch(null, null, this.thetaLong_, this.thetaLong_ == Long.MAX_VALUE) : new CompactTupleSketch(this.hashArr_, Util.copySummaryArray(this.summaryArr_), this.thetaLong_, false);
        if (reset) {
            this.reset();
        }
        return result;
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="hashArr and summaryArr are guaranteed to be valid due to the switch on CornerCase")
    public static <S extends Summary> CompactTupleSketch<S> aNotB(TupleSketch<S> skA, TupleSketch<S> skB) {
        if (skA == null || skB == null) {
            throw new SketchesArgumentException("Neither argument may be null for this stateless operation.");
        }
        long thetaLongA = skA.getThetaLong();
        int countA = skA.getRetainedEntries();
        boolean emptyA = skA.isEmpty();
        long thetaLongB = skB.getThetaLong();
        int countB = skB.getRetainedEntries();
        boolean emptyB = skB.isEmpty();
        int id = SetOperationCornerCases.createCornerCaseId(thetaLongA, countA, emptyA, thetaLongB, countB, emptyB);
        SetOperationCornerCases.CornerCase cCase = SetOperationCornerCases.CornerCase.caseIdToCornerCase(id);
        SetOperationCornerCases.AnotbAction anotbAction = cCase.getAnotbAction();
        CompactTupleSketch result = null;
        switch (anotbAction) {
            case EMPTY_1_0_T: {
                result = new CompactTupleSketch(null, null, Long.MAX_VALUE, true);
                break;
            }
            case DEGEN_MIN_0_F: {
                long thetaLong = Math.min(thetaLongA, thetaLongB);
                result = new CompactTupleSketch(null, null, thetaLong, false);
                break;
            }
            case DEGEN_THA_0_F: {
                result = new CompactTupleSketch(null, null, thetaLongA, false);
                break;
            }
            case TRIM_A: {
                DataArrays<S> daA = TupleAnotB.getCopyOfDataArraysTuple(skA);
                long[] hashArrA = daA.hashArr;
                S[] summaryArrA = daA.summaryArr;
                long minThetaLong = Math.min(thetaLongA, thetaLongB);
                DataArrays da = TupleAnotB.trimAndCopyDataArrays((long[])hashArrA, summaryArrA, (long)minThetaLong, (boolean)false);
                result = new CompactTupleSketch(da.hashArr, da.summaryArr, minThetaLong, skA.empty_);
                break;
            }
            case SKETCH_A: {
                DataArrays<S> daA = TupleAnotB.getCopyOfDataArraysTuple(skA);
                result = new CompactTupleSketch(daA.hashArr, daA.summaryArr, thetaLongA, skA.empty_);
                break;
            }
            case FULL_ANOTB: {
                int countR;
                DataArrays<S> daA = TupleAnotB.getCopyOfDataArraysTuple(skA);
                long minThetaLong = Math.min(thetaLongA, thetaLongB);
                DataArrays daR = TupleAnotB.getCopyOfResultArraysTuple((long)minThetaLong, (int)daA.hashArr.length, (long[])daA.hashArr, daA.summaryArr, skB);
                int n = countR = daR.hashArr == null ? 0 : daR.hashArr.length;
                result = countR == 0 ? new CompactTupleSketch(null, null, minThetaLong, minThetaLong == Long.MAX_VALUE) : new CompactTupleSketch(daR.hashArr, daR.summaryArr, minThetaLong, false);
            }
        }
        return result;
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="hashArr and summaryArr are guaranteed to be valid due to the switch on CornerCase")
    public static <S extends Summary> CompactTupleSketch<S> aNotB(TupleSketch<S> skA, ThetaSketch skB) {
        if (skA == null || skB == null) {
            throw new SketchesArgumentException("Neither argument may be null for this stateless operation.");
        }
        long thetaLongA = skA.getThetaLong();
        int countA = skA.getRetainedEntries();
        boolean emptyA = skA.isEmpty();
        long thetaLongB = skB.getThetaLong();
        int countB = skB.getRetainedEntries();
        boolean emptyB = skB.isEmpty();
        int id = SetOperationCornerCases.createCornerCaseId(thetaLongA, countA, emptyA, thetaLongB, countB, emptyB);
        SetOperationCornerCases.CornerCase cCase = SetOperationCornerCases.CornerCase.caseIdToCornerCase(id);
        SetOperationCornerCases.AnotbAction anotbAction = cCase.getAnotbAction();
        CompactTupleSketch result = null;
        switch (anotbAction) {
            case EMPTY_1_0_T: {
                result = new CompactTupleSketch(null, null, Long.MAX_VALUE, true);
                break;
            }
            case DEGEN_MIN_0_F: {
                long thetaLong = Math.min(thetaLongA, thetaLongB);
                result = new CompactTupleSketch(null, null, thetaLong, false);
                break;
            }
            case DEGEN_THA_0_F: {
                result = new CompactTupleSketch(null, null, thetaLongA, false);
                break;
            }
            case TRIM_A: {
                DataArrays<S> daA = TupleAnotB.getCopyOfDataArraysTuple(skA);
                long[] hashArrA = daA.hashArr;
                S[] summaryArrA = daA.summaryArr;
                long minThetaLong = Math.min(thetaLongA, thetaLongB);
                DataArrays da = TupleAnotB.trimAndCopyDataArrays((long[])hashArrA, summaryArrA, (long)minThetaLong, (boolean)false);
                result = new CompactTupleSketch(da.hashArr, da.summaryArr, minThetaLong, skA.empty_);
                break;
            }
            case SKETCH_A: {
                DataArrays<S> daA = TupleAnotB.getCopyOfDataArraysTuple(skA);
                result = new CompactTupleSketch(daA.hashArr, daA.summaryArr, thetaLongA, skA.empty_);
                break;
            }
            case FULL_ANOTB: {
                int countR;
                DataArrays<S> daA = TupleAnotB.getCopyOfDataArraysTuple(skA);
                long minThetaLong = Math.min(thetaLongA, thetaLongB);
                DataArrays daR = TupleAnotB.getCopyOfResultArraysTheta((long)minThetaLong, (int)daA.hashArr.length, (long[])daA.hashArr, daA.summaryArr, (ThetaSketch)skB);
                int n = countR = daR.hashArr == null ? 0 : daR.hashArr.length;
                result = countR == 0 ? new CompactTupleSketch(null, null, minThetaLong, minThetaLong == Long.MAX_VALUE) : new CompactTupleSketch(daR.hashArr, daR.summaryArr, minThetaLong, false);
            }
        }
        return result;
    }

    private static <S extends Summary> DataArrays<S> getCopyOfDataArraysTuple(TupleSketch<S> sk) {
        DataArrays da = new DataArrays();
        CompactTupleSketch csk = sk instanceof CompactTupleSketch ? (CompactTupleSketch)sk : ((QuickSelectSketch)sk).compact();
        int count = csk.getRetainedEntries();
        if (count == 0) {
            da.hashArr = null;
            da.summaryArr = null;
        } else {
            da.hashArr = (long[])csk.getHashArr().clone();
            da.summaryArr = Util.copySummaryArray((Summary[])csk.getSummaryArr());
        }
        return da;
    }

    private static <S extends Summary> DataArrays<S> getCopyOfResultArraysTuple(long minThetaLong, int countA, long[] hashArrA, S[] summaryArrA, TupleSketch<S> skB) {
        long[] hashTableB;
        DataArrays daR = new DataArrays();
        if (skB instanceof CompactTupleSketch) {
            CompactTupleSketch cskB = (CompactTupleSketch)skB;
            int countB = skB.getRetainedEntries();
            hashTableB = HashOperations.convertToHashTable(cskB.getHashArr(), countB, minThetaLong, 0.9375);
        } else {
            QuickSelectSketch qskB = (QuickSelectSketch)skB;
            hashTableB = qskB.getHashTable();
        }
        long[] tmpHashArrA = new long[countA];
        Summary[] tmpSummaryArrA = Util.newSummaryArray(summaryArrA, (int)countA);
        int lgHTBLen = org.apache.datasketches.common.Util.exactLog2OfLong(hashTableB.length);
        int nonMatches = 0;
        for (int i = 0; i < countA; ++i) {
            int index;
            long hash = hashArrA[i];
            if (hash == 0L || hash >= minThetaLong || (index = HashOperations.hashSearch(hashTableB, lgHTBLen, hash)) != -1) continue;
            tmpHashArrA[nonMatches] = hash;
            tmpSummaryArrA[nonMatches] = summaryArrA[i].copy();
            ++nonMatches;
        }
        daR.hashArr = Arrays.copyOfRange(tmpHashArrA, 0, nonMatches);
        daR.summaryArr = Arrays.copyOfRange(tmpSummaryArrA, 0, nonMatches);
        return daR;
    }

    private static <S extends Summary> DataArrays<S> getCopyOfResultArraysTheta(long minThetaLong, int countA, long[] hashArrA, S[] summaryArrA, ThetaSketch skB) {
        long[] hashTableB;
        long[] hashCacheB;
        DataArrays daB = new DataArrays();
        try {
            hashCacheB = (long[])GET_CACHE.invoke((Object)skB, new Object[0]);
        }
        catch (Exception e) {
            throw new SketchesStateException("Reflection Exception " + String.valueOf(e));
        }
        if (skB instanceof CompactThetaSketch) {
            int countB = skB.getRetainedEntries(true);
            hashTableB = HashOperations.convertToHashTable(hashCacheB, countB, minThetaLong, 0.9375);
        } else {
            hashTableB = hashCacheB;
        }
        long[] tmpHashArrA = new long[countA];
        Summary[] tmpSummaryArrA = Util.newSummaryArray(summaryArrA, (int)countA);
        int lgHTBLen = org.apache.datasketches.common.Util.exactLog2OfLong(hashTableB.length);
        int nonMatches = 0;
        for (int i = 0; i < countA; ++i) {
            int index;
            long hash = hashArrA[i];
            if (hash == 0L || hash >= minThetaLong || (index = HashOperations.hashSearch(hashTableB, lgHTBLen, hash)) != -1) continue;
            tmpHashArrA[nonMatches] = hash;
            tmpSummaryArrA[nonMatches] = summaryArrA[i].copy();
            ++nonMatches;
        }
        daB.hashArr = Arrays.copyOfRange(tmpHashArrA, 0, nonMatches);
        daB.summaryArr = Arrays.copyOfRange(tmpSummaryArrA, 0, nonMatches);
        return daB;
    }

    private static <S extends Summary> DataArrays<S> trimAndCopyDataArrays(long[] hashArr, S[] summaryArr, long minThetaLong, boolean copy) {
        int countIn = hashArr.length;
        long[] tmpHashArr = new long[countIn];
        Summary[] tmpSummaryArr = Util.newSummaryArray(summaryArr, (int)countIn);
        int countResult = 0;
        for (int i = 0; i < countIn; ++i) {
            long hash = hashArr[i];
            if (hash >= minThetaLong) continue;
            tmpHashArr[countResult] = hash;
            tmpSummaryArr[countResult] = copy ? summaryArr[i].copy() : summaryArr[i];
            ++countResult;
        }
        DataArrays da = new DataArrays();
        da.hashArr = Arrays.copyOfRange(tmpHashArr, 0, countResult);
        da.summaryArr = Arrays.copyOfRange(tmpSummaryArr, 0, countResult);
        return da;
    }

    public void reset() {
        this.empty_ = true;
        this.thetaLong_ = Long.MAX_VALUE;
        this.hashArr_ = null;
        this.summaryArr_ = null;
        this.curCount_ = 0;
    }

    static {
        try {
            GET_CACHE = ThetaSketch.class.getDeclaredMethod("getCache", new Class[0]);
            GET_CACHE.setAccessible(true);
        }
        catch (Exception e) {
            throw new SketchesStateException("Could not reflect getCache(): " + String.valueOf(e));
        }
    }

    static class DataArrays<S extends Summary> {
        long[] hashArr;
        S[] summaryArr;

        DataArrays() {
        }
    }
}

