/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.common.Util;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllUnion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HllSketchMergeOrderTest {
    private static final int LgK = 11;

    @Test
    public void testDataSketchHLLMergeOrderDependency() {
        int ppo = 131072;
        HllSketch sketchA = this.createUniquePowerSeriesSketch(0x800000000000000L, 131072, 0x1000000000000000L);
        HllSketch sketchB = this.createUniquePowerSeriesSketch(0x1000000000000000L, 131072, 0x2000000000000000L);
        HllSketch sketchC = this.createUniquePowerSeriesSketch(0x2000000000000000L, 131072, 0x4000000000000000L);
        double skAEst = sketchA.getCompositeEstimate();
        double skBEst = sketchB.getCompositeEstimate();
        double skCEst = sketchC.getCompositeEstimate();
        double skA_RE = skAEst / 131072.0 - 1.0;
        double skB_RE = skBEst / 131072.0 - 1.0;
        double skC_RE = skCEst / 131072.0 - 1.0;
        HllSketchMergeOrderTest.println("");
        HllSketchMergeOrderTest.println("SketchA estimate: " + skAEst + ", RE%: " + skA_RE * 100.0);
        HllSketchMergeOrderTest.println("SketchB estimate: " + skBEst + ", RE%: " + skB_RE * 100.0);
        HllSketchMergeOrderTest.println("SketchC estimate: " + skCEst + ", RE%: " + skC_RE * 100.0);
        HllSketchMergeOrderTest.println("\nNOTE: Sketch Relative Error for Composite Estimator for LgK = 11 is +/- 4.6% at 95% confidence.\n");
        double estABC = this.mergeThreeSketches(sketchA, sketchB, sketchC);
        double estACB = this.mergeThreeSketches(sketchA, sketchC, sketchB);
        double estBAC = this.mergeThreeSketches(sketchB, sketchA, sketchC);
        double estBCA = this.mergeThreeSketches(sketchB, sketchC, sketchA);
        double estCAB = this.mergeThreeSketches(sketchC, sketchA, sketchB);
        double estCBA = this.mergeThreeSketches(sketchC, sketchB, sketchA);
        HllSketchMergeOrderTest.println("Merge order ABC: " + estABC);
        HllSketchMergeOrderTest.println("Merge order ACB: " + estACB);
        HllSketchMergeOrderTest.println("Merge order BAC: " + estBAC);
        HllSketchMergeOrderTest.println("Merge order BCA: " + estBCA);
        HllSketchMergeOrderTest.println("Merge order CAB: " + estCAB);
        HllSketchMergeOrderTest.println("Merge order CBA: " + estCBA);
        Assert.assertTrue((estABC == estACB && estABC == estBAC && estABC == estBCA && estABC == estCAB && estABC == estCBA ? 1 : 0) != 0);
    }

    private HllSketch createUniquePowerSeriesSketch(long baseValue, int ppo, long limit) {
        HllSketch sketch = new HllSketch(11);
        int count = 0;
        long lastp = 0L;
        long p = baseValue;
        while (p < limit) {
            sketch.update(p);
            ++count;
            lastp = p;
            p = Util.pwr2SeriesNext((int)ppo, (long)p);
        }
        HllSketchMergeOrderTest.println("BaseValue: " + baseValue + ", limit: " + limit + ", Count: " + count + ", lastPt: " + lastp);
        return sketch;
    }

    private double mergeThreeSketches(HllSketch s1, HllSketch s2, HllSketch s3) {
        HllUnion union = new HllUnion(11);
        union.update(s1);
        union.update(s2);
        union.update(s3);
        return union.getCompositeEstimate();
    }

    public void checkNewGenerator() {
        long baseValue = 0x800000000000000L;
        int ppo = 1024;
        long limit = 0x1000000000000000L;
        int count = 0;
        long lastp = 0L;
        long p = 0x800000000000000L;
        while (p < 0x1000000000000000L) {
            HllSketchMergeOrderTest.println(++count + ", " + p);
            lastp = p;
            p = Util.pwr2SeriesNext((int)1024, (long)p);
        }
        HllSketchMergeOrderTest.println("\nPPO:       1024");
        HllSketchMergeOrderTest.println("Count:     " + count);
        HllSketchMergeOrderTest.println("baseValue: 576460752303423488");
        HllSketchMergeOrderTest.println("last p:    " + lastp);
        HllSketchMergeOrderTest.println("limit:     1152921504606846976");
    }

    private static void println(Object o) {
    }
}

