/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DFDLSetBits$;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.RecipeOpWithSubRecipes;
import org.apache.daffodil.runtime1.infoset.DINode;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class DFDLSetBits
extends RecipeOpWithSubRecipes
implements Product {
    private final List bitRecipes;

    public static DFDLSetBits apply(List<CompiledDPath> list) {
        return DFDLSetBits$.MODULE$.apply(list);
    }

    public static DFDLSetBits fromProduct(Product product) {
        return DFDLSetBits$.MODULE$.fromProduct(product);
    }

    public static DFDLSetBits unapply(DFDLSetBits dFDLSetBits) {
        return DFDLSetBits$.MODULE$.unapply(dFDLSetBits);
    }

    public DFDLSetBits(List<CompiledDPath> bitRecipes) {
        this.bitRecipes = bitRecipes;
        super(bitRecipes);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DFDLSetBits)) return false;
        DFDLSetBits dFDLSetBits = (DFDLSetBits)object;
        List<CompiledDPath> list = this.bitRecipes();
        List<CompiledDPath> list2 = dFDLSetBits.bitRecipes();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!dFDLSetBits.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DFDLSetBits;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "DFDLSetBits";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "bitRecipes";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public List<CompiledDPath> bitRecipes() {
        return this.bitRecipes;
    }

    @Override
    public void run(DState dstate) {
        int byteVal = 0;
        if (this.bitRecipes().length() != 8) {
            throw Assert$.MODULE$.abort("Invariant broken: DFDLSetBits.this.bitRecipes.length.==(8)");
        }
        DINode saved = dstate.currentNode();
        int i = 0;
        List bitR = this.bitRecipes();
        while (i < 8) {
            CompiledDPath br = (CompiledDPath)bitR.head();
            dstate.setCurrentNode(saved);
            br.run(dstate);
            int currentVal = dstate.intValue();
            if (this.processValue(currentVal)) {
                byteVal |= 1 << i;
            }
            ++i;
            bitR = (List)bitR.tail();
        }
        Short res = DataValue$.MODULE$.toDataValue((short)byteVal);
        dstate.setCurrentValue(res);
    }

    private boolean processValue(int i) {
        if (i < 0 || i > 1) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("dfdl:setBits arguments must each be 0 or 1, but value was: %s."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
        }
        return i != 0;
    }

    public DFDLSetBits copy(List<CompiledDPath> bitRecipes) {
        return new DFDLSetBits(bitRecipes);
    }

    public List<CompiledDPath> copy$default$1() {
        return this.bitRecipes();
    }

    public List<CompiledDPath> _1() {
        return this.bitRecipes();
    }
}

