/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class IssuesTest
extends JexlTestCase {
    public IssuesTest() {
        super("IssuesTest", null);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    @Test
    void test11() throws Exception {
        String[] exprs;
        JexlEngine jexl = IssuesTest.createEngine(false);
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        options.setStrict(true);
        ctxt.set("a", null);
        for (String s : exprs = new String[]{"a % b"}) {
            JexlExpression expr = jexl.createExpression(s);
            Assertions.assertThrows(JexlException.class, () -> expr.evaluate((JexlContext)ctxt), () -> s + " : should have failed due to null argument");
        }
    }

    @Test
    void test40() throws Exception {
        Engine jexl = new Engine();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.set((JexlEngine)jexl);
        options.setSilent(false);
        ctxt.set("derived", new Derived());
        JexlExpression expr = jexl.createExpression("derived.foo()");
        Object value = expr.evaluate((JexlContext)ctxt);
        Assertions.assertTrue((boolean)((Boolean)value));
    }

    @Test
    void test42() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine uel = jexl.createJxltEngine();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.set(jexl);
        options.setStrict(false);
        options.setStrictArithmetic(false);
        ctxt.set("ax", "ok");
        JxltEngine.Expression expr = uel.createExpression("${ax+(bx)}");
        Object value = expr.evaluate((JexlContext)ctxt);
        Assertions.assertEquals((Object)"ok", (Object)value);
    }

    @Test
    void test44() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        JexlScript script = jexl.createScript("'hello world!'//commented");
        Assertions.assertEquals((Object)"hello world!", (Object)script.execute((JexlContext)ctxt));
        script = jexl.createScript("'hello world!'; //commented\n'bye...'");
        Assertions.assertEquals((Object)"bye...", (Object)script.execute((JexlContext)ctxt));
        script = jexl.createScript("'hello world!'## commented");
        Assertions.assertEquals((Object)"hello world!", (Object)script.execute((JexlContext)ctxt));
        script = jexl.createScript("'hello world!';## commented\n'bye...'");
        Assertions.assertEquals((Object)"bye...", (Object)script.execute((JexlContext)ctxt));
    }

    @Test
    void test47() throws Exception {
        Engine jexl = new Engine();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        JexlExpression expr = jexl.createExpression("true//false\n");
        Object value = expr.evaluate((JexlContext)ctxt);
        Assertions.assertTrue((boolean)((Boolean)value));
        expr = jexl.createExpression("/*true*/false");
        value = expr.evaluate((JexlContext)ctxt);
        Assertions.assertFalse((boolean)((Boolean)value));
        expr = jexl.createExpression("/*\"true\"*/false");
        value = expr.evaluate((JexlContext)ctxt);
        Assertions.assertFalse((boolean)((Boolean)value));
    }

    @Test
    void test48() throws Exception {
        Engine jexl = new Engine();
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        options.setStrict(true);
        options.setSilent(false);
        String jexlExp = "(foo.getInner().foo() eq true) and (foo.getInner().goo() = (foo.getInner().goo()+1-1))";
        jc.set("foo", new Foo());
        Assertions.assertNotNull((Object)((JexlException.Assignment)Assertions.assertThrows(JexlException.Assignment.class, () -> IssuesTest.lambda$test48$2((JexlEngine)jexl))).toString());
    }

    @Test
    void test49() throws Exception {
        Engine jexl = new Engine();
        HashMap vars = new HashMap();
        MapContext ctxt = new MapContext(vars);
        String stmt = "a = 'b'; c = 'd';";
        JexlScript expr = jexl.createScript("a = 'b'; c = 'd';");
        expr.execute((JexlContext)ctxt);
        Assertions.assertTrue((vars.get("a").equals("b") && vars.get("c").equals("d") ? 1 : 0) != 0, (String)"JEXL-49 is not fixed");
    }

    @Test
    void test52base() throws Exception {
        Engine jexl = (Engine)IssuesTest.createEngine(false);
        Uberspect uber = (Uberspect)jexl.getUberspect();
        String[] names = uber.getMethodNames(Another.class);
        Assertions.assertTrue((names.length > 0 ? 1 : 0) != 0, (String)"should find methods");
        int found = 0;
        for (String name : names) {
            if (!"foo".equals(name) && !"goo".equals(name)) continue;
            ++found;
        }
        Assertions.assertEquals((int)2, (int)found, (String)"should have foo & goo");
        names = uber.getFieldNames(Another.class);
        Assertions.assertTrue((names.length > 0 ? 1 : 0) != 0, (String)"should find fields");
        found = 0;
        for (String name : names) {
            if (!"name".equals(name)) continue;
            ++found;
        }
        Assertions.assertEquals((int)1, (int)found, (String)"should have name");
    }

    @Test
    void test62() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        MapContext vars = new MapContext();
        JexlEvalContext ctxt = new JexlEvalContext((JexlContext)vars);
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrict(true);
        options.setSilent(true);
        JexlScript jscript = jexl.createScript("dummy.hashCode()");
        Assertions.assertNull((Object)jscript.execute((JexlContext)ctxt), () -> ((JexlScript)jscript).getSourceText());
        ctxt.set("dummy", "abcd");
        Assertions.assertEquals((Object)"abcd".hashCode(), (Object)jscript.execute((JexlContext)ctxt), () -> ((JexlScript)jscript).getSourceText());
        jscript = jexl.createScript("dummy.hashCode");
        Assertions.assertNull((Object)jscript.execute((JexlContext)ctxt), () -> ((JexlScript)jscript).getSourceText());
        vars.clear();
        JexlExpression jexpr = jexl.createExpression("dummy.hashCode()");
        Assertions.assertNull((Object)jexpr.evaluate((JexlContext)ctxt), () -> ((JexlExpression)jexpr).toString());
        ctxt.set("dummy", "abcd");
        Assertions.assertEquals((Object)"abcd".hashCode(), (Object)jexpr.evaluate((JexlContext)ctxt), () -> ((JexlExpression)jexpr).toString());
        jexpr = jexl.createExpression("dummy.hashCode");
        Assertions.assertNull((Object)jexpr.evaluate((JexlContext)ctxt), () -> ((JexlExpression)jexpr).toString());
    }

    @Test
    void test87() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        JexlExpression divide = jexl.createExpression("l / r");
        JexlExpression modulo = jexl.createExpression("l % r");
        ctxt.set("l", BigInteger.valueOf(7L));
        ctxt.set("r", BigInteger.valueOf(2L));
        Assertions.assertEquals((Object)BigInteger.valueOf(3L), (Object)divide.evaluate((JexlContext)ctxt));
        Assertions.assertTrue((boolean)jexl.getArithmetic().equals((Object)1, modulo.evaluate((JexlContext)ctxt)));
        ctxt.set("l", BigDecimal.valueOf(7L));
        ctxt.set("r", BigDecimal.valueOf(2L));
        Assertions.assertEquals((Object)BigDecimal.valueOf(3.5), (Object)divide.evaluate((JexlContext)ctxt));
        Assertions.assertTrue((boolean)jexl.getArithmetic().equals((Object)1, modulo.evaluate((JexlContext)ctxt)));
    }

    @Test
    void test90() throws Exception {
        String[] fexprs;
        JexlEngine jexl = IssuesTest.createEngine(false);
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        for (String fexpr : fexprs = new String[]{"a=3 b=4", "while(a) while(a)", "1 2", "if (true) 2; 3 {}", "while (x) 1 if (y) 2 3"}) {
            Assertions.assertThrows(JexlException.class, () -> jexl.createScript(fexpr));
        }
        String[] exprs = new String[]{"if (x) {1} if (y) {2}", "if (x) 1 if (y) 2", "while (x) 1 if (y) 2 else 3", "for(z : [3, 4, 5]) { z } y ? 2 : 1", "for(z : [3, 4, 5]) { z } if (y) 2 else 1"};
        ctxt.set("x", Boolean.FALSE);
        ctxt.set("y", Boolean.TRUE);
        for (String expr : exprs) {
            JexlScript s = jexl.createScript(expr);
            Assertions.assertEquals((Object)2, (Object)s.execute((JexlContext)ctxt));
        }
        IssuesTest.debuggerCheck(jexl);
    }

    @Test
    void test97() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        for (char v = 'a'; v <= 'z'; v = (char)(v + '\u0001')) {
            ctxt.set(Character.toString(v), 10);
        }
        String input = "(((((((((((((((((((((((((z+y)/x)*w)-v)*u)/t)-s)*r)/q)+p)-o)*n)-m)+l)*k)+j)/i)+h)*g)+f)/e)+d)-c)/b)+a)";
        long start = System.nanoTime();
        JexlExpression script = jexl.createExpression("(((((((((((((((((((((((((z+y)/x)*w)-v)*u)/t)-s)*r)/q)+p)-o)*n)-m)+l)*k)+j)/i)+h)*g)+f)/e)+d)-c)/b)+a)");
        Object value = script.evaluate((JexlContext)ctxt);
        Assertions.assertEquals((Object)11, (Object)value);
        long end = System.nanoTime();
        double millisec = (double)(end - start) / 1000000.0;
        double limit = 200.0;
        Assertions.assertTrue((millisec < 200.0 ? 1 : 0) != 0, () -> "Expected parse to take less than 200.0ms, actual " + millisec);
    }

    @Test
    void test98() throws Exception {
        String[] exprs = new String[]{"fn:replace('DOMAIN\\somename', '\\\\', '\\\\\\\\')", "fn:replace(\"DOMAIN\\somename\", \"\\\\\", \"\\\\\\\\\")", "fn:replace('DOMAIN\\somename', '\\u005c', '\\u005c\\u005c')"};
        HashMap<String, fn98> funcs = new HashMap<String, fn98>();
        funcs.put("fn", new fn98());
        JexlEngine jexl = new JexlBuilder().namespaces(funcs).create();
        for (String expr : exprs) {
            Object value = jexl.createExpression(expr).evaluate(null);
            Assertions.assertEquals((Object)"DOMAIN\\\\somename", (Object)value, (String)expr);
        }
    }

    private static /* synthetic */ void lambda$test48$2(JexlEngine jexl) throws Throwable {
        jexl.createExpression("(foo.getInner().foo() eq true) and (foo.getInner().goo() = (foo.getInner().goo()+1-1))");
    }

    static class Derived
    extends Base {
        Derived() {
        }

        @Override
        public boolean foo() {
            return true;
        }
    }

    public static class Foo {
        private final Another inner = new Another();

        Foo() {
        }

        public Another getInner() {
            return this.inner;
        }
    }

    public static class Another {
        public String name = "whatever";
        private final Boolean foo = Boolean.TRUE;

        public Boolean foo() {
            return this.foo;
        }

        public int goo() {
            return 100;
        }
    }

    public static class fn98 {
        public String replace(String str, String target, String replacement) {
            return str.replace(target, replacement);
        }
    }

    public static abstract class Base {
        public abstract boolean foo();
    }
}

