/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeMatcher;
import org.apache.commons.configuration2.tree.NodeNameMatchers;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestNodeNameMatchers {
    private static final String NODE_NAME = "TestNodeName";
    private NodeHandler<ImmutableNode> handler;

    private static ImmutableNode createNode(String name) {
        return new ImmutableNode.Builder().name(name).create();
    }

    private void checkMatcherWithNullInput(NodeMatcher<String> matcher) {
        Assertions.assertFalse((boolean)matcher.matches((Object)TestNodeNameMatchers.createNode(NODE_NAME), this.handler, null));
        Assertions.assertFalse((boolean)matcher.matches((Object)TestNodeNameMatchers.createNode(null), this.handler, (Object)NODE_NAME));
    }

    @BeforeEach
    public void setUp() throws Exception {
        InMemoryNodeModel model = new InMemoryNodeModel();
        this.handler = model.getNodeHandler();
    }

    @Test
    void testEqualsIgnoreCaseMatch() {
        ImmutableNode node = TestNodeNameMatchers.createNode(NODE_NAME);
        Assertions.assertTrue((boolean)NodeNameMatchers.EQUALS_IGNORE_CASE.matches((Object)node, this.handler, (Object)NODE_NAME));
        Assertions.assertTrue((boolean)NodeNameMatchers.EQUALS_IGNORE_CASE.matches((Object)node, this.handler, (Object)StringUtils.toRootLowerCase((String)NODE_NAME)));
        Assertions.assertTrue((boolean)NodeNameMatchers.EQUALS_IGNORE_CASE.matches((Object)node, this.handler, (Object)StringUtils.toRootUpperCase((String)NODE_NAME)));
    }

    @Test
    void testEqualsIgnoreCaseNoMatch() {
        ImmutableNode node = TestNodeNameMatchers.createNode(NODE_NAME);
        Assertions.assertFalse((boolean)NodeNameMatchers.EQUALS_IGNORE_CASE.matches((Object)node, this.handler, (Object)"TestNodeName_other"));
    }

    @Test
    void testEqualsIgnoreCaseNullCriterion() {
        this.checkMatcherWithNullInput((NodeMatcher<String>)NodeNameMatchers.EQUALS_IGNORE_CASE);
    }

    @Test
    void testEqualsMatch() {
        ImmutableNode node = TestNodeNameMatchers.createNode(NODE_NAME);
        Assertions.assertTrue((boolean)NodeNameMatchers.EQUALS.matches((Object)node, this.handler, (Object)NODE_NAME));
    }

    @Test
    void testEqualsNoMatch() {
        ImmutableNode node = TestNodeNameMatchers.createNode(NODE_NAME);
        Assertions.assertFalse((boolean)NodeNameMatchers.EQUALS.matches((Object)node, this.handler, (Object)"TestNodeName_other"));
        Assertions.assertFalse((boolean)NodeNameMatchers.EQUALS.matches((Object)node, this.handler, (Object)StringUtils.toRootLowerCase((String)NODE_NAME)));
    }

    @Test
    void testEqualsNullCriterion() {
        this.checkMatcherWithNullInput((NodeMatcher<String>)NodeNameMatchers.EQUALS);
    }
}

